/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.concurrent.StripedExecutor;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;

public class TenantApplications {
    private static final Logger log = Logger.getLogger(TenantApplications.class.getName());
    private final Curator curator;
    private final Path applicationsPath;
    private final Path locksPath;
    private final Curator.DirectoryCache directoryCache;
    private final ReloadHandler reloadHandler;
    private final Executor zkWatcherExecutor;

    private TenantApplications(Curator curator, ReloadHandler reloadHandler, TenantName tenant, ExecutorService zkCacheExecutor, StripedExecutor<TenantName> zkWatcherExecutor) {
        this.curator = curator;
        this.applicationsPath = TenantRepository.getApplicationsPath(tenant);
        this.locksPath = TenantRepository.getLocksPath(tenant);
        this.reloadHandler = reloadHandler;
        this.zkWatcherExecutor = command -> zkWatcherExecutor.execute((Object)tenant, command);
        this.directoryCache = curator.createDirectoryCache(this.applicationsPath.getAbsolute(), false, false, zkCacheExecutor);
        this.directoryCache.start();
        this.directoryCache.addListener(this::childEvent);
    }

    public static TenantApplications create(GlobalComponentRegistry registry, ReloadHandler reloadHandler, TenantName tenant) {
        return new TenantApplications(registry.getCurator(), reloadHandler, tenant, registry.getZkCacheExecutor(), registry.getZkWatcherExecutor());
    }

    public List<ApplicationId> activeApplications() {
        return this.curator.getChildren(this.applicationsPath).stream().sorted().map(ApplicationId::fromSerializedForm).filter(id -> this.activeSessionOf((ApplicationId)id).isPresent()).collect(Collectors.toUnmodifiableList());
    }

    public boolean exists(ApplicationId id) {
        return this.curator.exists(this.applicationPath(id));
    }

    public Optional<Long> activeSessionOf(ApplicationId id) {
        String data = this.curator.getData(this.applicationPath(id)).map(Utf8::toString).orElseThrow(() -> new NotFoundException("No such application id: '" + id + "'"));
        return data.isEmpty() ? Optional.empty() : Optional.of(Long.parseLong(data));
    }

    public Transaction createPutTransaction(ApplicationId applicationId, long sessionId) {
        return new CuratorTransaction(this.curator).add((Transaction.Operation)CuratorOperations.setData((String)this.applicationPath(applicationId).getAbsolute(), (byte[])Utf8.toAsciiBytes((long)sessionId)));
    }

    public void createApplication(ApplicationId id) {
        try (Lock lock = this.lock(id);){
            this.curator.create(this.applicationPath(id));
        }
    }

    public long requireActiveSessionOf(ApplicationId applicationId) {
        return this.activeSessionOf(applicationId).orElseThrow(() -> new IllegalArgumentException("Application '" + applicationId + "' has no active session."));
    }

    public CuratorTransaction createDeleteTransaction(ApplicationId applicationId) {
        return CuratorTransaction.from((List)CuratorOperations.deleteAll((String)this.applicationPath(applicationId).getAbsolute(), (Curator)this.curator), (Curator)this.curator);
    }

    public void removeUnusedApplications() {
        this.reloadHandler.removeApplicationsExcept(Set.copyOf(this.activeApplications()));
    }

    public void close() {
        this.directoryCache.close();
    }

    public Lock lock(ApplicationId id) {
        return this.curator.lock(this.lockPath(id), Duration.ofMinutes(1L));
    }

    private void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
        this.zkWatcherExecutor.execute(() -> {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    this.applicationAdded(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                    break;
                }
                case CHILD_REMOVED: {
                    this.applicationRemoved(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                    break;
                }
                case CHILD_UPDATED: {
                    break;
                }
            }
            this.removeUnusedApplications();
        });
    }

    private void applicationRemoved(ApplicationId applicationId) {
        this.reloadHandler.removeApplication(applicationId);
        log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Application removed: " + applicationId);
    }

    private void applicationAdded(ApplicationId applicationId) {
        log.log((Level)LogLevel.DEBUG, TenantRepository.logPre(applicationId) + "Application added: " + applicationId);
    }

    private Path applicationPath(ApplicationId id) {
        return this.applicationsPath.append(id.serializedForm());
    }

    private Path lockPath(ApplicationId id) {
        return this.locksPath.append(id.serializedForm());
    }
}

