/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.path.Path;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointSerializer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;

public class ContainerEndpointsCache {
    private final Path cachePath;
    private final Curator curator;

    public ContainerEndpointsCache(Path tenantPath, Curator curator) {
        this.cachePath = tenantPath.append("containerEndpointsCache/");
        this.curator = curator;
    }

    public List<ContainerEndpoint> read(ApplicationId applicationId) {
        Optional optionalData = this.curator.getData(this.containerEndpointsPath(applicationId));
        return optionalData.map(SlimeUtils::jsonToSlime).map(ContainerEndpointSerializer::endpointListFromSlime).orElseGet(List::of);
    }

    public void write(ApplicationId applicationId, List<ContainerEndpoint> endpoints) {
        if (endpoints.isEmpty()) {
            return;
        }
        Slime slime = ContainerEndpointSerializer.endpointListToSlime(endpoints);
        try {
            byte[] bytes = SlimeUtils.toJsonBytes((Slime)slime);
            this.curator.set(this.containerEndpointsPath(applicationId), bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error writing endpoints of: " + applicationId, e);
        }
    }

    public CuratorTransaction delete(ApplicationId application) {
        if (!this.curator.exists(this.containerEndpointsPath(application))) {
            return CuratorTransaction.empty((Curator)this.curator);
        }
        return CuratorTransaction.from((CuratorOperation)CuratorOperations.delete((String)this.containerEndpointsPath(application).getAbsolute()), (Curator)this.curator);
    }

    private Path containerEndpointsPath(ApplicationId applicationId) {
        return this.cachePath.append(applicationId.serializedForm());
    }
}

