/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.serviceview;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.yahoo.vespa.serviceview.Cluster;
import com.yahoo.vespa.serviceview.Service;
import com.yahoo.vespa.serviceview.bindings.ApplicationView;
import com.yahoo.vespa.serviceview.bindings.ClusterView;
import com.yahoo.vespa.serviceview.bindings.HostService;
import com.yahoo.vespa.serviceview.bindings.ModelResponse;
import com.yahoo.vespa.serviceview.bindings.ServicePort;
import com.yahoo.vespa.serviceview.bindings.ServiceView;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ServiceModel {
    private static final String CLUSTERCONTROLLER_TYPENAME = "container-clustercontroller";
    private static final String CONTENT_CLUSTER_TYPENAME = "content";
    private final Map<String, Service> servicesMap;
    @NonNull
    public final ImmutableList<Cluster> clusters;

    ServiceModel(ModelResponse modelConfig) {
        HashBasedTable services = HashBasedTable.create();
        for (Object h : modelConfig.hosts) {
            String hostName = ((HostService)h).name;
            for (com.yahoo.vespa.serviceview.bindings.Service s : ((HostService)h).services) {
                ServiceModel.addService((Table<String, String, List<Service>>)services, hostName, s);
            }
        }
        ArrayList<Cluster> sortingBuffer = new ArrayList<Cluster>();
        for (Table.Cell c : services.cellSet()) {
            sortingBuffer.add(new Cluster((String)c.getRowKey(), (String)c.getColumnKey(), (List)c.getValue()));
        }
        Collections.sort(sortingBuffer);
        ImmutableList.Builder clustersBuilder = new ImmutableList.Builder();
        clustersBuilder.addAll(sortingBuffer);
        this.clusters = clustersBuilder.build();
        HashMap<String, Service> seenIdentifiers = new HashMap<String, Service>();
        for (Cluster c : this.clusters) {
            for (Service s : c.services) {
                List<String> identifiers = s.getIdentifiers();
                for (String identifier : identifiers) {
                    if (seenIdentifiers.containsKey(identifier)) {
                        throw new RuntimeException("Hash collision between " + seenIdentifiers.get(identifier) + " and " + s + ".");
                    }
                    seenIdentifiers.put(identifier, s);
                }
            }
        }
        ImmutableMap.Builder servicesBuilder = new ImmutableMap.Builder();
        servicesBuilder.putAll(seenIdentifiers);
        this.servicesMap = servicesBuilder.build();
    }

    private static void addService(Table<String, String, List<Service>> services, String hostName, com.yahoo.vespa.serviceview.bindings.Service s) {
        boolean hasStateApi = false;
        int statePort = 0;
        ArrayList<Integer> ports = new ArrayList<Integer>(s.ports.size());
        for (ServicePort port : s.ports) {
            ports.add(port.number);
            if (hasStateApi || !port.hasTags(new String[]{"http", "state"})) continue;
            hasStateApi = true;
            statePort = port.number;
        }
        if (hasStateApi) {
            Service service = new Service(s.type, hostName, statePort, s.clustername, s.clustertype, s.configid, ports, s.name);
            ServiceModel.getAndSetEntry(services, s.clustername, s.clustertype).add(service);
        }
    }

    private static List<Service> getAndSetEntry(Table<String, String, List<Service>> services, String clusterName, String clusterType) {
        ArrayList serviceList = (ArrayList)services.get((Object)clusterName, (Object)clusterType);
        if (serviceList == null) {
            serviceList = new ArrayList();
            services.put((Object)clusterName, (Object)clusterType, serviceList);
        }
        return serviceList;
    }

    public ApplicationView showAllClusters(String uriBase, String applicationIdentifier) {
        ApplicationView response = new ApplicationView();
        ArrayList<ClusterView> clusterViews = new ArrayList<ClusterView>();
        for (Cluster c : this.clusters) {
            clusterViews.add(this.showCluster(c, uriBase, applicationIdentifier));
        }
        response.clusters = clusterViews;
        return response;
    }

    private ClusterView showCluster(Cluster c, String uriBase, String applicationIdentifier) {
        ArrayList<ServiceView> services = new ArrayList<ServiceView>();
        for (Service s : c.services) {
            ServiceView service = new ServiceView();
            StringBuilder buffer = this.getLinkBuilder(uriBase).append(applicationIdentifier).append('/');
            service.url = buffer.append("service/").append(s.getIdentifier(s.statePort)).append("/state/v1/").toString();
            service.serviceType = s.serviceType;
            service.serviceName = s.name;
            service.configId = s.configId;
            service.host = s.host;
            this.addLegacyLink(uriBase, applicationIdentifier, s, service);
            services.add(service);
        }
        ClusterView v = new ClusterView();
        v.services = services;
        v.name = c.name;
        v.type = c.type;
        if (CONTENT_CLUSTER_TYPENAME.equals(c.type)) {
            Service s;
            s = this.getFirstClusterController();
            StringBuilder buffer = this.getLinkBuilder(uriBase).append(applicationIdentifier).append('/');
            buffer.append("service/").append(s.getIdentifier(s.statePort)).append("/cluster/v2/").append(c.name);
            v.url = buffer.toString();
        } else {
            v.url = null;
        }
        return v;
    }

    private void addLegacyLink(String uriBase, String applicationIdentifier, Service s, ServiceView service) {
        if (s.serviceType.equals("storagenode") || s.serviceType.equals("distributor")) {
            StringBuilder legacyBuffer = this.getLinkBuilder(uriBase);
            legacyBuffer.append("legacy/").append(applicationIdentifier).append('/');
            legacyBuffer.append("service/").append(s.getIdentifier(s.statePort)).append('/');
            service.legacyStatusPages = legacyBuffer.toString();
        }
    }

    private Service getFirstServiceInstanceByType(@NonNull String typeName) {
        for (Cluster c : this.clusters) {
            for (Service s : c.services) {
                if (!typeName.equals(s.serviceType)) continue;
                return s;
            }
        }
        throw new IllegalStateException("This installation has but no service of required type: " + typeName + ".");
    }

    private Service getFirstClusterController() {
        return this.getFirstServiceInstanceByType(CLUSTERCONTROLLER_TYPENAME);
    }

    private StringBuilder getLinkBuilder(String uriBase) {
        StringBuilder buffer = new StringBuilder(uriBase);
        if (!uriBase.endsWith("/")) {
            buffer.append('/');
        }
        return buffer;
    }

    public String toString() {
        int maxLen = 3;
        StringBuilder builder = new StringBuilder();
        builder.append("ServiceModel [clusters=").append(this.clusters.subList(0, Math.min(this.clusters.size(), 3))).append("]");
        return builder.toString();
    }

    public Service getService(String identifier) {
        return this.servicesMap.get(identifier);
    }

    public Service resolve(String host, int port, Service self) {
        Integer portAsObject = port;
        String realHost = "localhost".equals(host) ? self.host : host;
        for (Cluster c : this.clusters) {
            for (Service s : c.services) {
                if (!s.host.equals(realHost) || !s.ports.contains(portAsObject)) continue;
                return s;
            }
        }
        throw new IllegalArgumentException("No registered service owns port " + port + " on host " + realHost + ".");
    }
}

