/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.host;

import com.google.common.collect.Collections2;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.host.HostValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HostRegistry<T>
implements HostValidator<T> {
    private static final Logger log = Logger.getLogger(HostRegistry.class.getName());
    private final Map<String, T> host2KeyMap = new ConcurrentHashMap<String, T>();

    public T getKeyForHost(String hostName) {
        return this.host2KeyMap.get(hostName);
    }

    public synchronized void update(T key, Collection<String> newHosts) {
        this.verifyHosts(key, newHosts);
        Collection<String> currentHosts = this.getHostsForKey(key);
        log.log((Level)LogLevel.DEBUG, () -> "Setting hosts for key '" + key + "', newHosts: " + newHosts + ", currentHosts: " + currentHosts);
        Collection<String> removedHosts = HostRegistry.getRemovedHosts(newHosts, currentHosts);
        this.removeHosts(removedHosts);
        this.addHosts(key, newHosts);
    }

    @Override
    public synchronized void verifyHosts(T key, Collection<String> newHosts) {
        for (String host : newHosts) {
            if (!this.hostAlreadyTaken(host, key)) continue;
            throw new IllegalArgumentException("'" + key + "' tried to allocate host '" + host + "', but the host is already taken by '" + this.host2KeyMap.get(host) + "'");
        }
    }

    public synchronized void removeHostsForKey(T key) {
        this.host2KeyMap.entrySet().removeIf(entry -> entry.getValue().equals(key));
    }

    public synchronized Collection<String> getAllHosts() {
        return Collections.unmodifiableCollection(new ArrayList<String>(this.host2KeyMap.keySet()));
    }

    synchronized Collection<String> getHostsForKey(T key) {
        return this.host2KeyMap.entrySet().stream().filter(entry -> entry.getValue().equals(key)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private boolean hostAlreadyTaken(String host, T key) {
        return this.host2KeyMap.containsKey(host) && !key.equals(this.host2KeyMap.get(host));
    }

    private static Collection<String> getRemovedHosts(Collection<String> newHosts, Collection<String> previousHosts) {
        return Collections2.filter(previousHosts, host -> !newHosts.contains(host));
    }

    private void removeHosts(Collection<String> removedHosts) {
        for (String host : removedHosts) {
            log.log((Level)LogLevel.DEBUG, () -> "Removing " + host);
            this.host2KeyMap.remove(host);
        }
    }

    private void addHosts(T key, Collection<String> newHosts) {
        for (String host : newHosts) {
            log.log((Level)LogLevel.DEBUG, () -> "Adding " + host);
            this.host2KeyMap.put(host, key);
        }
    }
}

