/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.provision;

import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.ProvisionLogger;
import java.util.List;
import java.util.stream.Collectors;

public class StaticProvisioner
implements HostProvisioner {
    private final AllocatedHosts allocatedHosts;
    private final HostProvisioner fallback;

    public StaticProvisioner(AllocatedHosts allocatedHosts, HostProvisioner fallback) {
        this.allocatedHosts = allocatedHosts;
        this.fallback = fallback;
    }

    public HostSpec allocateHost(String alias) {
        throw new UnsupportedOperationException("Allocating a single host from provisioning info is not supported");
    }

    public List<HostSpec> prepare(ClusterSpec cluster, Capacity capacity, int groups, ProvisionLogger logger) {
        List<HostSpec> hostsAlreadyAllocatedToCluster = this.allocatedHosts.getHosts().stream().filter(host -> host.membership().isPresent() && this.matches(((ClusterMembership)host.membership().get()).cluster(), cluster)).collect(Collectors.toList());
        if (!hostsAlreadyAllocatedToCluster.isEmpty()) {
            return hostsAlreadyAllocatedToCluster;
        }
        return this.fallback.prepare(cluster, capacity, groups, logger);
    }

    private boolean matches(ClusterSpec nodeCluster, ClusterSpec requestedCluster) {
        if (requestedCluster.group().isPresent()) {
            return nodeCluster.equals((Object)requestedCluster);
        }
        return nodeCluster.satisfies(requestedCluster);
    }
}

