/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.EndpointCertificateMetadata;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.path.Path;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.SlimeUtils;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateMetadataSerializer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.util.Optional;

public class EndpointCertificateMetadataStore {
    private final Path path;
    private final Curator curator;

    public EndpointCertificateMetadataStore(Curator curator, Path tenantPath) {
        this.curator = curator;
        this.path = tenantPath.append("tlsSecretsKeys/");
    }

    public Optional<EndpointCertificateMetadata> readEndpointCertificateMetadata(ApplicationId application) {
        try {
            Optional data = this.curator.getData(this.endpointCertificateMetadataPathOf(application));
            if (data.isEmpty() || ((byte[])data.get()).length == 0) {
                return Optional.empty();
            }
            Slime slime = SlimeUtils.jsonToSlime((byte[])((byte[])data.get()));
            EndpointCertificateMetadata endpointCertificateMetadata = EndpointCertificateMetadataSerializer.fromSlime((Inspector)slime.get());
            return Optional.of(endpointCertificateMetadata);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading TLS secret key of " + application, e);
        }
    }

    public void writeEndpointCertificateMetadata(ApplicationId application, EndpointCertificateMetadata endpointCertificateMetadata) {
        try {
            Slime slime = new Slime();
            EndpointCertificateMetadataSerializer.toSlime(endpointCertificateMetadata, slime.setObject());
            this.curator.set(this.endpointCertificateMetadataPathOf(application), SlimeUtils.toJsonBytes((Slime)slime));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write TLS secret key of " + application, e);
        }
    }

    public CuratorTransaction delete(ApplicationId application) {
        if (!this.curator.exists(this.endpointCertificateMetadataPathOf(application))) {
            return CuratorTransaction.empty((Curator)this.curator);
        }
        return CuratorTransaction.from((CuratorOperation)CuratorOperations.delete((String)this.endpointCertificateMetadataPathOf(application).getAbsolute()), (Curator)this.curator);
    }

    private Path endpointCertificateMetadataPathOf(ApplicationId application) {
        return this.path.append(application.serializedForm());
    }
}

