/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.util.http.VespaHttpClientBuilder;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.ProxyResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public class TesterClient {
    private final HttpClient httpClient = VespaHttpClientBuilder.create().build();
    private static final Logger logger = Logger.getLogger(TesterClient.class.getName());

    public HttpResponse getStatus(String testerHostname, int port) {
        URI testerUri;
        try {
            testerUri = new URIBuilder().setScheme("https").setHost(testerHostname).setPort(port).setPath("/tester/v1/status").build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "Failed to get tester status");
    }

    public HttpResponse getLog(String testerHostname, int port, Long after) {
        URI testerUri;
        try {
            testerUri = new URIBuilder().setScheme("https").setHost(testerHostname).setPort(port).setPath("/tester/v1/log").addParameter("after", String.valueOf(after)).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "Failed to get tester logs");
    }

    public HttpResponse startTests(String testerHostname, String suite, String config) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private HttpResponse execute(HttpUriRequest request, String messageIfRequestFails) {
        logger.log(LogLevel.INFO, "Sending request to tester container " + request.getURI().toString());
        try {
            return new ProxyResponse(this.httpClient.execute(request));
        }
        catch (IOException e) {
            logger.warning(messageIfRequestFails + ": " + Exceptions.toMessageString((Throwable)e));
            return HttpErrorResponse.internalServerError(Exceptions.toMessageString((Throwable)e));
        }
    }
}

