/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.TlsSecrets;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.path.Path;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.SlimeUtils;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.util.Optional;

public class TlsSecretsKeys {
    private final Path path;
    private final SecretStore secretStore;
    private final Curator curator;

    public TlsSecretsKeys(Curator curator, Path tenantPath, SecretStore secretStore) {
        this.curator = curator;
        this.path = tenantPath.append("tlsSecretsKeys/");
        this.secretStore = secretStore;
    }

    public Optional<TlsSecrets> readTlsSecretsKeyFromZookeeper(ApplicationId application) {
        try {
            Optional data = this.curator.getData(this.tlsSecretsKeyOf(application));
            if (data.isEmpty() || ((byte[])data.get()).length == 0) {
                return Optional.empty();
            }
            Slime slime = SlimeUtils.jsonToSlime((byte[])((byte[])data.get()));
            Cursor inspector = slime.get();
            switch (inspector.type()) {
                case STRING: {
                    return this.readFromSecretStore(Optional.ofNullable(inspector.asString()));
                }
                case OBJECT: {
                    TlsSecretsMetadata tlsSecretsInfo = new TlsSecretsMetadata();
                    tlsSecretsInfo.certName = inspector.field("certName").asString();
                    tlsSecretsInfo.keyName = inspector.field("keyName").asString();
                    tlsSecretsInfo.version = Math.toIntExact(inspector.field("version").asLong());
                    return Optional.of(this.readFromSecretStore(tlsSecretsInfo));
                }
            }
            throw new IllegalArgumentException("Unknown format encountered for TLS secrets metadata!");
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading TLS secret key of " + application, e);
        }
    }

    public void writeTlsSecretsKeyToZooKeeper(ApplicationId application, String tlsSecretsKey) {
        if (tlsSecretsKey == null) {
            return;
        }
        this.writeTlsSecretsAsString(application, tlsSecretsKey);
    }

    private void writeTlsSecretsAsString(ApplicationId application, String tlsSecretsKey) {
        try {
            Slime slime = new Slime();
            slime.setString(tlsSecretsKey);
            this.curator.set(this.tlsSecretsKeyOf(application), SlimeUtils.toJsonBytes((Slime)slime));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write TLS secret key of " + application, e);
        }
    }

    void writeTlsSecretsMetadata(ApplicationId application, TlsSecretsMetadata tlsSecretsMetadata) {
        try {
            Slime slime = new Slime();
            Cursor cursor = slime.setObject();
            cursor.setString("certName", tlsSecretsMetadata.certName);
            cursor.setString("keyName", tlsSecretsMetadata.keyName);
            cursor.setLong("version", (long)tlsSecretsMetadata.version);
            this.curator.set(this.tlsSecretsKeyOf(application), SlimeUtils.toJsonBytes((Slime)slime));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write TLS secret key of " + application, e);
        }
    }

    public Optional<TlsSecrets> getTlsSecrets(Optional<String> secretKeyname, ApplicationId applicationId) {
        if (secretKeyname == null || secretKeyname.isEmpty()) {
            return this.readTlsSecretsKeyFromZookeeper(applicationId);
        }
        return this.readFromSecretStore(secretKeyname);
    }

    private Optional<TlsSecrets> readFromSecretStore(Optional<String> secretKeyname) {
        if (secretKeyname.isEmpty()) {
            return Optional.empty();
        }
        try {
            String cert = this.secretStore.getSecret(secretKeyname.get() + "-cert");
            String key = this.secretStore.getSecret(secretKeyname.get() + "-key");
            return Optional.of(new TlsSecrets(cert, key));
        }
        catch (RuntimeException e) {
            return Optional.of(TlsSecrets.MISSING);
        }
    }

    private TlsSecrets readFromSecretStore(TlsSecretsMetadata tlsSecretsMetadata) {
        try {
            String cert = this.secretStore.getSecret(tlsSecretsMetadata.certName, tlsSecretsMetadata.version);
            String key = this.secretStore.getSecret(tlsSecretsMetadata.keyName, tlsSecretsMetadata.version);
            return new TlsSecrets(cert, key);
        }
        catch (RuntimeException e) {
            return TlsSecrets.MISSING;
        }
    }

    public CuratorTransaction delete(ApplicationId application) {
        if (!this.curator.exists(this.tlsSecretsKeyOf(application))) {
            return CuratorTransaction.empty((Curator)this.curator);
        }
        return CuratorTransaction.from((CuratorOperation)CuratorOperations.delete((String)this.tlsSecretsKeyOf(application).getAbsolute()), (Curator)this.curator);
    }

    private Path tlsSecretsKeyOf(ApplicationId application) {
        return this.path.append(application.serializedForm());
    }

    static class TlsSecretsMetadata {
        static final String keyNameField = "keyName";
        static final String certNameField = "certName";
        static final String versionField = "version";
        String keyName;
        String certName;
        int version;

        TlsSecretsMetadata() {
        }
    }
}

