/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.server.session.LocalSessionLoader;
import com.yahoo.vespa.config.server.session.LocalSessionRepo;
import com.yahoo.vespa.config.server.session.RemoteSessionFactory;
import com.yahoo.vespa.config.server.session.RemoteSessionRepo;
import com.yahoo.vespa.config.server.session.SessionFactory;
import com.yahoo.vespa.config.server.session.SessionFactoryImpl;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.server.tenant.TenantRequestHandler;
import java.util.Collections;

public class TenantBuilder {
    private final GlobalComponentRegistry componentRegistry;
    private final TenantName tenant;
    private RemoteSessionRepo remoteSessionRepo;
    private LocalSessionRepo localSessionRepo;
    private SessionFactory sessionFactory;
    private LocalSessionLoader localSessionLoader;
    private TenantApplications applicationRepo;
    private TenantRequestHandler reloadHandler;
    private RequestHandler requestHandler;
    private RemoteSessionFactory remoteSessionFactory;
    private HostValidator<ApplicationId> hostValidator;

    private TenantBuilder(GlobalComponentRegistry componentRegistry, TenantName tenant) {
        this.componentRegistry = componentRegistry;
        this.tenant = tenant;
    }

    public static TenantBuilder create(GlobalComponentRegistry componentRegistry, TenantName tenant) {
        return new TenantBuilder(componentRegistry, tenant);
    }

    public TenantBuilder withSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        return this;
    }

    public TenantBuilder withLocalSessionRepo(LocalSessionRepo localSessionRepo) {
        this.localSessionRepo = localSessionRepo;
        return this;
    }

    public TenantBuilder withApplicationRepo(TenantApplications applicationRepo) {
        this.applicationRepo = applicationRepo;
        return this;
    }

    public TenantBuilder withRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
        return this;
    }

    public Tenant build() {
        this.createTenantRequestHandler();
        this.createApplicationRepo();
        this.createRemoteSessionFactory();
        this.createRemoteSessionRepo();
        this.createSessionFactory();
        this.createLocalSessionRepo();
        return new Tenant(this.tenant, TenantRepository.getTenantPath(this.tenant), this.sessionFactory, this.localSessionRepo, this.remoteSessionRepo, this.requestHandler, this.reloadHandler, this.applicationRepo, this.componentRegistry.getCurator());
    }

    private void createLocalSessionRepo() {
        if (this.localSessionRepo == null) {
            this.localSessionRepo = new LocalSessionRepo(this.tenant, this.componentRegistry, this.localSessionLoader);
        }
    }

    private void createSessionFactory() {
        if (this.sessionFactory == null || this.localSessionLoader == null) {
            SessionFactoryImpl impl = new SessionFactoryImpl(this.componentRegistry, this.applicationRepo, this.hostValidator, this.tenant);
            if (this.sessionFactory == null) {
                this.sessionFactory = impl;
            }
            if (this.localSessionLoader == null) {
                this.localSessionLoader = impl;
            }
        }
    }

    private void createApplicationRepo() {
        if (this.applicationRepo == null) {
            this.applicationRepo = this.reloadHandler.applications();
        }
    }

    private void createTenantRequestHandler() {
        if (this.requestHandler == null || this.reloadHandler == null) {
            TenantRequestHandler impl;
            this.hostValidator = impl = new TenantRequestHandler(this.componentRegistry.getMetrics(), this.tenant, Collections.singletonList(this.componentRegistry.getReloadListener()), ConfigResponseFactory.create(this.componentRegistry.getConfigserverConfig()), this.componentRegistry);
            if (this.requestHandler == null) {
                this.requestHandler = impl;
            }
            this.reloadHandler = impl;
        }
    }

    private void createRemoteSessionFactory() {
        if (this.remoteSessionFactory == null) {
            this.remoteSessionFactory = new RemoteSessionFactory(this.componentRegistry, this.tenant);
        }
    }

    private void createRemoteSessionRepo() {
        this.remoteSessionRepo = new RemoteSessionRepo(this.componentRegistry, this.remoteSessionFactory, this.reloadHandler, this.tenant, this.applicationRepo);
    }

    public TenantName getTenantName() {
        return this.tenant;
    }
}

