/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.vespa.config.server.session.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class SessionRepo<SESSIONTYPE extends Session> {
    private final HashMap<Long, SESSIONTYPE> sessions = new HashMap();

    public synchronized void addSession(SESSIONTYPE session) {
        if (this.sessions.containsKey(((Session)session).getSessionId())) {
            throw new IllegalArgumentException("There already exists a session with id '" + ((Session)session).getSessionId() + "'");
        }
        this.sessions.put(((Session)session).getSessionId(), session);
    }

    synchronized void removeSession(long id) {
        if (!this.sessions.containsKey(id)) {
            throw new IllegalArgumentException("No session with id '" + id + "' exists");
        }
        this.sessions.remove(id);
    }

    public synchronized SESSIONTYPE getSession(long id) {
        return (SESSIONTYPE)((Session)this.sessions.get(id));
    }

    public synchronized Collection<SESSIONTYPE> listSessions() {
        return new ArrayList<SESSIONTYPE>(this.sessions.values());
    }
}

