/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;

public abstract class Session {
    private final long sessionId;
    protected final TenantName tenant;
    protected final SessionZooKeeperClient zooKeeperClient;

    protected Session(TenantName tenant, long sessionId, SessionZooKeeperClient zooKeeperClient) {
        this.tenant = tenant;
        this.sessionId = sessionId;
        this.zooKeeperClient = zooKeeperClient;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    public Status getStatus() {
        return this.zooKeeperClient.readStatus();
    }

    public String toString() {
        return "Session,id=" + this.sessionId;
    }

    public TenantName getTenant() {
        return this.tenant;
    }

    public String logPre() {
        return TenantRepository.logPre(this.getTenant());
    }

    public long getCreateTime() {
        return this.zooKeeperClient.readCreateTime();
    }

    public static enum Status {
        NEW,
        PREPARE,
        ACTIVATE,
        DEACTIVATE,
        DELETE,
        NONE;


        public static Status parse(String data) {
            for (Status status : Status.values()) {
                if (!status.name().equals(data)) continue;
                return status;
            }
            return NEW;
        }
    }
}

