/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.util.http.VespaHttpClientBuilder;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class LogRetriever {
    private final HttpClient httpClient = VespaHttpClientBuilder.create().build();
    private static final Logger logger = Logger.getLogger(LogRetriever.class.getName());

    public HttpResponse getLogs(String logServerHostname) {
        HttpGet get = new HttpGet(logServerHostname);
        try {
            return new ProxyResponse(this.httpClient.execute((HttpUriRequest)get));
        }
        catch (IOException e) {
            logger.warning("Failed to get logs: " + Exceptions.toMessageString((Throwable)e));
            return HttpErrorResponse.internalServerError(Exceptions.toMessageString((Throwable)e));
        }
    }

    private static class ProxyResponse
    extends HttpResponse {
        private final org.apache.http.HttpResponse clientResponse;

        private ProxyResponse(org.apache.http.HttpResponse clientResponse) {
            super(clientResponse.getStatusLine().getStatusCode());
            this.clientResponse = clientResponse;
        }

        public String getContentType() {
            return Optional.ofNullable(this.clientResponse.getFirstHeader("Content-Type")).map(Header::getValue).orElseGet(() -> super.getContentType());
        }

        public void render(OutputStream outputStream) throws IOException {
            this.clientResponse.getEntity().writeTo(outputStream);
        }
    }
}

