/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.http.HttpFetcher;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.RequestTimeoutException;
import com.yahoo.vespa.config.server.http.StaticResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.logging.Logger;

public class SimpleHttpFetcher
implements HttpFetcher {
    private static final Logger logger = Logger.getLogger(SimpleHttpFetcher.class.getName());

    @Override
    public HttpResponse get(HttpFetcher.Params params, URL url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(params.readTimeoutMs);
            int code = connection.getResponseCode();
            String contentType = connection.getContentType();
            InputStream inputStream = connection.getInputStream();
            StaticResponse response = new StaticResponse(code, contentType, inputStream);
            return response;
        }
        catch (SocketTimeoutException e) {
            String message = "Timed out after " + params.readTimeoutMs + " ms reading response from " + url;
            logger.log(LogLevel.WARNING, message, e);
            throw new RequestTimeoutException(message);
        }
        catch (IOException e) {
            String message = "Failed to get response from " + url;
            logger.log(LogLevel.WARNING, message, e);
            throw new InternalServerException(message);
        }
    }
}

