/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.rpc.security;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.security.NodeIdentifier;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.vespa.config.server.host.HostRegistries;
import com.yahoo.vespa.config.server.rpc.RequestHandlerProvider;
import com.yahoo.vespa.config.server.rpc.security.MultiTenantRpcAuthorizer;
import com.yahoo.vespa.config.server.rpc.security.NoopRpcAuthorizer;
import com.yahoo.vespa.config.server.rpc.security.RpcAuthorizer;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.StringFlag;

public class DefaultRpcAuthorizerProvider
implements Provider<RpcAuthorizer> {
    private final RpcAuthorizer rpcAuthorizer;

    @Inject
    public DefaultRpcAuthorizerProvider(ConfigserverConfig config, NodeIdentifier nodeIdentifier, HostRegistries hostRegistries, RequestHandlerProvider handlerProvider, FlagSource flagSource) {
        String authorizerMode = ((StringFlag)Flags.CONFIGSERVER_RPC_AUTHORIZER.bindTo(flagSource)).value();
        boolean useMultiTenantAuthorizer = TransportSecurityUtils.isTransportSecurityEnabled() && config.multitenant() && config.hostedVespa() && !authorizerMode.equals("disable");
        this.rpcAuthorizer = useMultiTenantAuthorizer ? new MultiTenantRpcAuthorizer(nodeIdentifier, hostRegistries, handlerProvider, DefaultRpcAuthorizerProvider.toMultiTenantRpcAuthorizerMode(authorizerMode), DefaultRpcAuthorizerProvider.getThreadPoolSize(config)) : new NoopRpcAuthorizer();
    }

    private static MultiTenantRpcAuthorizer.Mode toMultiTenantRpcAuthorizerMode(String authorizerMode) {
        switch (authorizerMode) {
            case "log-only": {
                return MultiTenantRpcAuthorizer.Mode.LOG_ONLY;
            }
            case "enforce": {
                return MultiTenantRpcAuthorizer.Mode.ENFORCE;
            }
        }
        throw new IllegalArgumentException("Invalid authorizer mode: " + authorizerMode);
    }

    private static int getThreadPoolSize(ConfigserverConfig config) {
        return config.numRpcThreads() != 0 ? config.numRpcThreads() : 8;
    }

    public RpcAuthorizer get() {
        return this.rpcAuthorizer;
    }

    public void deconstruct() {
    }
}

