/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.collections.Tuple2;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.server.http.HttpConfigRequest;
import com.yahoo.vespa.config.server.http.v2.HttpConfigRequests;
import com.yahoo.vespa.config.server.http.v2.TenantRequest;

public class HttpListConfigsRequest
implements TenantRequest {
    private final ConfigKey<?> key;
    private final ApplicationId appId;
    private final boolean recursive;
    private final boolean fullAppId;

    private HttpListConfigsRequest(ConfigKey<?> key, ApplicationId appId, boolean recursive, boolean fullAppId) {
        this.key = key;
        this.appId = appId;
        this.recursive = recursive;
        this.fullAppId = fullAppId;
    }

    public static HttpListConfigsRequest createFromListRequest(HttpRequest req) {
        BindingMatch<?> bm = HttpConfigRequests.getBindingMatch(req, "http://*/config/v2/tenant/*/application/*/environment/*/region/*/instance/*/", "http://*/config/v2/tenant/*/application/*/");
        if (bm.groupCount() > 4) {
            return HttpListConfigsRequest.createFromListRequestFullAppId(req, bm);
        }
        return HttpListConfigsRequest.createFromListRequestSimpleAppId(req, bm);
    }

    private static HttpListConfigsRequest createFromListRequestSimpleAppId(HttpRequest req, BindingMatch<?> bm) {
        TenantName tenant = TenantName.from((String)bm.group(2));
        ApplicationName application = ApplicationName.from((String)bm.group(3));
        return new HttpListConfigsRequest(null, new ApplicationId.Builder().tenant(tenant).applicationName(application).build(), req.getBooleanProperty("recursive"), false);
    }

    private static HttpListConfigsRequest createFromListRequestFullAppId(HttpRequest req, BindingMatch<?> bm) {
        String tenant = bm.group(2);
        String application = bm.group(3);
        String environment = bm.group(4);
        String region = bm.group(5);
        String instance = bm.group(6);
        ApplicationId appId = new ApplicationId.Builder().tenant(tenant).applicationName(application).instanceName(instance).build();
        return new HttpListConfigsRequest(null, appId, req.getBooleanProperty("recursive"), true);
    }

    public static HttpListConfigsRequest createFromNamedListRequest(HttpRequest req) {
        BindingMatch<?> bm = HttpConfigRequests.getBindingMatch(req, "http://*/config/v2/tenant/*/application/*/environment/*/region/*/instance/*/*/*/", "http://*/config/v2/tenant/*/application/*/*/*/");
        if (bm.groupCount() > 6) {
            return HttpListConfigsRequest.createFromNamedListRequestFullAppId(req, bm);
        }
        return HttpListConfigsRequest.createFromNamedListRequestSimpleAppId(req, bm);
    }

    private static HttpListConfigsRequest createFromNamedListRequestSimpleAppId(HttpRequest req, BindingMatch<?> bm) {
        TenantName tenant = TenantName.from((String)bm.group(2));
        ApplicationName application = ApplicationName.from((String)bm.group(3));
        String conf = bm.group(4);
        String cId = bm.groupCount() >= 6 ? bm.group(5) : "";
        Tuple2<String, String> nns = HttpConfigRequest.nameAndNamespace(conf);
        String cName = (String)nns.first;
        String cNamespace = (String)nns.second;
        ConfigKey key = new ConfigKey(cName, cId, cNamespace);
        return new HttpListConfigsRequest(key, new ApplicationId.Builder().tenant(tenant).applicationName(application).build(), req.getBooleanProperty("recursive"), false);
    }

    private static HttpListConfigsRequest createFromNamedListRequestFullAppId(HttpRequest req, BindingMatch<?> bm) {
        String tenant = bm.group(2);
        String application = bm.group(3);
        String environment = bm.group(4);
        String region = bm.group(5);
        String instance = bm.group(6);
        String conf = bm.group(7);
        String cId = bm.groupCount() >= 9 ? bm.group(8) : "";
        Tuple2<String, String> nns = HttpConfigRequest.nameAndNamespace(conf);
        String cName = (String)nns.first;
        String cNamespace = (String)nns.second;
        ConfigKey key = new ConfigKey(cName, cId, cNamespace);
        ApplicationId appId = new ApplicationId.Builder().tenant(tenant).applicationName(application).instanceName(instance).build();
        return new HttpListConfigsRequest(key, appId, req.getBooleanProperty("recursive"), true);
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isFullAppId() {
        return this.fullAppId;
    }

    public ConfigKey<?> getKey() {
        return this.key;
    }
}

