/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.component.Version;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Rotation;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.SlimeUtils;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointSerializer;
import java.time.Clock;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class PrepareParams {
    static final String APPLICATION_NAME_PARAM_NAME = "applicationName";
    static final String INSTANCE_PARAM_NAME = "instance";
    static final String IGNORE_VALIDATION_PARAM_NAME = "ignoreValidationErrors";
    static final String DRY_RUN_PARAM_NAME = "dryRun";
    static final String VERBOSE_PARAM_NAME = "verbose";
    static final String VESPA_VERSION_PARAM_NAME = "vespaVersion";
    static final String ROTATIONS_PARAM_NAME = "rotations";
    static final String CONTAINER_ENDPOINTS_PARAM_NAME = "containerEndpoints";
    static final String TLS_SECRETS_KEY_NAME_PARAM_NAME = "tlsSecretsKeyName";
    private final ApplicationId applicationId;
    private final TimeoutBudget timeoutBudget;
    private final boolean ignoreValidationErrors;
    private final boolean dryRun;
    private final boolean verbose;
    private final boolean isBootstrap;
    private final Optional<Version> vespaVersion;
    private final Set<Rotation> rotations;
    private final List<ContainerEndpoint> containerEndpoints;
    private final Optional<String> tlsSecretsKeyName;

    private PrepareParams(ApplicationId applicationId, TimeoutBudget timeoutBudget, boolean ignoreValidationErrors, boolean dryRun, boolean verbose, boolean isBootstrap, Optional<Version> vespaVersion, Set<Rotation> rotations, List<ContainerEndpoint> containerEndpoints, Optional<String> tlsSecretsKeyName) {
        this.timeoutBudget = timeoutBudget;
        this.applicationId = applicationId;
        this.ignoreValidationErrors = ignoreValidationErrors;
        this.dryRun = dryRun;
        this.verbose = verbose;
        this.isBootstrap = isBootstrap;
        this.vespaVersion = vespaVersion;
        this.rotations = rotations;
        this.containerEndpoints = containerEndpoints;
        if (rotations != null && !rotations.isEmpty() && !containerEndpoints.isEmpty()) {
            throw new IllegalArgumentException("Cannot set both rotations and containerEndpoints");
        }
        this.tlsSecretsKeyName = tlsSecretsKeyName;
    }

    public static PrepareParams fromHttpRequest(HttpRequest request, TenantName tenant, Duration barrierTimeout) {
        return new Builder().ignoreValidationErrors(request.getBooleanProperty(IGNORE_VALIDATION_PARAM_NAME)).dryRun(request.getBooleanProperty(DRY_RUN_PARAM_NAME)).verbose(request.getBooleanProperty(VERBOSE_PARAM_NAME)).timeoutBudget(SessionHandler.getTimeoutBudget(request, barrierTimeout)).applicationId(PrepareParams.createApplicationId(request, tenant)).vespaVersion(request.getProperty(VESPA_VERSION_PARAM_NAME)).rotations(request.getProperty(ROTATIONS_PARAM_NAME)).containerEndpoints(request.getProperty(CONTAINER_ENDPOINTS_PARAM_NAME)).tlsSecretsKeyName(request.getProperty(TLS_SECRETS_KEY_NAME_PARAM_NAME)).build();
    }

    private static ApplicationId createApplicationId(HttpRequest request, TenantName tenant) {
        return new ApplicationId.Builder().tenant(tenant).applicationName(PrepareParams.getPropertyWithDefault(request, APPLICATION_NAME_PARAM_NAME, "default")).instanceName(PrepareParams.getPropertyWithDefault(request, INSTANCE_PARAM_NAME, "default")).build();
    }

    private static String getPropertyWithDefault(HttpRequest request, String propertyName, String defaultProperty) {
        return PrepareParams.getProperty(request, propertyName).orElse(defaultProperty);
    }

    private static Optional<String> getProperty(HttpRequest request, String propertyName) {
        return Optional.ofNullable(request.getProperty(propertyName));
    }

    public String getApplicationName() {
        return this.applicationId.application().value();
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public Optional<Version> vespaVersion() {
        return this.vespaVersion;
    }

    public Set<Rotation> rotations() {
        return this.rotations;
    }

    public List<ContainerEndpoint> containerEndpoints() {
        return this.containerEndpoints;
    }

    public boolean ignoreValidationErrors() {
        return this.ignoreValidationErrors;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isBootstrap() {
        return this.isBootstrap;
    }

    public TimeoutBudget getTimeoutBudget() {
        return this.timeoutBudget;
    }

    public Optional<String> tlsSecretsKeyName() {
        return this.tlsSecretsKeyName;
    }

    public static class Builder {
        private boolean ignoreValidationErrors = false;
        private boolean dryRun = false;
        private boolean verbose = false;
        private boolean isBootstrap = false;
        private ApplicationId applicationId = ApplicationId.defaultId();
        private TimeoutBudget timeoutBudget = new TimeoutBudget(Clock.systemUTC(), Duration.ofSeconds(30L));
        private Optional<Version> vespaVersion = Optional.empty();
        private Set<Rotation> rotations;
        private List<ContainerEndpoint> containerEndpoints = List.of();
        private Optional<String> tlsSecretsKeyName = Optional.empty();

        public Builder applicationId(ApplicationId applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder ignoreValidationErrors(boolean ignoreValidationErrors) {
            this.ignoreValidationErrors = ignoreValidationErrors;
            return this;
        }

        public Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder isBootstrap(boolean isBootstrap) {
            this.isBootstrap = isBootstrap;
            return this;
        }

        public Builder timeoutBudget(TimeoutBudget timeoutBudget) {
            this.timeoutBudget = timeoutBudget;
            return this;
        }

        public Builder vespaVersion(String vespaVersion) {
            Optional<Object> version = Optional.empty();
            if (vespaVersion != null && !vespaVersion.isEmpty()) {
                version = Optional.of(Version.fromString((String)vespaVersion));
            }
            this.vespaVersion = version;
            return this;
        }

        public Builder vespaVersion(Version vespaVersion) {
            this.vespaVersion = Optional.ofNullable(vespaVersion);
            return this;
        }

        public Builder rotations(String rotationsString) {
            this.rotations = new LinkedHashSet<Rotation>();
            if (rotationsString != null && !rotationsString.isEmpty()) {
                String[] rotations;
                for (String s : rotations = rotationsString.split(",")) {
                    this.rotations.add(new Rotation(s));
                }
            }
            return this;
        }

        public Builder containerEndpoints(String serialized) {
            if (serialized == null) {
                return this;
            }
            Slime slime = SlimeUtils.jsonToSlime((String)serialized);
            this.containerEndpoints = ContainerEndpointSerializer.endpointListFromSlime(slime);
            return this;
        }

        public Builder tlsSecretsKeyName(String tlsSecretsKeyName) {
            this.tlsSecretsKeyName = Optional.ofNullable(tlsSecretsKeyName).filter(s -> !s.isEmpty());
            return this;
        }

        public PrepareParams build() {
            return new PrepareParams(this.applicationId, this.timeoutBudget, this.ignoreValidationErrors, this.dryRun, this.verbose, this.isBootstrap, this.vespaVersion, this.rotations, this.containerEndpoints, this.tlsSecretsKeyName);
        }
    }
}

