/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ZKApplication {
    private final ConfigCurator zk;
    private final Path appPath;

    ZKApplication(ConfigCurator zk, Path appPath) {
        this.zk = zk;
        this.appPath = appPath;
    }

    List<NamedReader> getAllDataFromDirectory(String path, String fileNameSuffix, boolean recursive) {
        return this.getAllDataFromDirectory(path, "", fileNameSuffix, recursive);
    }

    private List<NamedReader> getAllDataFromDirectory(String path, String namePrefix, String fileNameSuffix, boolean recursive) {
        String fullPath = this.getFullPath(path);
        ArrayList<NamedReader> result = new ArrayList<NamedReader>();
        List<String> children = this.getChildren(path);
        try {
            for (String child : children) {
                if (fileNameSuffix == null || child.endsWith(fileNameSuffix)) {
                    result.add(new NamedReader(namePrefix + child, ZKApplication.reader(this.zk.getData(fullPath, child))));
                }
                if (!recursive) continue;
                result.addAll(this.getAllDataFromDirectory(path + "/" + child, namePrefix + child + "/", fileNameSuffix, recursive));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve all data from '" + fullPath + "' in zookeeper", e);
        }
    }

    Reader getDataReader(String path, String node) {
        String data = this.getData(path, node);
        if (data == null) {
            throw new IllegalArgumentException("No node for " + this.getFullPath(path) + "/" + node + " exists");
        }
        return ZKApplication.reader(data);
    }

    public String getData(String path, String node) {
        try {
            return this.zk.getData(this.getFullPath(path), node);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not retrieve node '" + this.getFullPath(path) + "/" + node + "' in zookeeper", e);
        }
    }

    public String getData(String path) {
        try {
            return this.zk.getData(this.getFullPath(path));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not retrieve path '" + this.getFullPath(path) + "' in zookeeper", e);
        }
    }

    public byte[] getBytes(String path) {
        try {
            return this.zk.getBytes(this.getFullPath(path));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not retrieve path '" + this.getFullPath(path) + "' in zookeeper", e);
        }
    }

    void putData(String path, String data) {
        try {
            this.zk.putData(this.getFullPath(path), data);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not put data to node '" + this.getFullPath(path) + "' in zookeeper", e);
        }
    }

    public boolean exists(String path, String node) {
        return this.zk.exists(this.getFullPath(path), node);
    }

    public boolean exists(String path) {
        return this.zk.exists(this.getFullPath(path));
    }

    private String getFullPath(String path) {
        Path fullPath = this.appPath;
        if (path != null) {
            fullPath = this.appPath.append(path);
        }
        return fullPath.getAbsolute();
    }

    void deleteRecurse(String path) {
        this.zk.deleteRecurse(this.getFullPath(path));
    }

    public List<String> getChildren(String path) {
        String fullPath = this.getFullPath(path);
        if (!this.zk.exists(fullPath)) {
            return Collections.emptyList();
        }
        return this.zk.getChildren(fullPath);
    }

    private static Reader reader(String string) {
        return new StringReader(string);
    }

    public void create(String path) {
        if (path != null && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        try {
            this.zk.createNode(this.getFullPath((String)path));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    Reader getDataReader(String path) {
        String data = this.getData(path);
        if (data == null) {
            throw new IllegalArgumentException("No node for " + this.getFullPath(path) + " exists");
        }
        return ZKApplication.reader(data);
    }
}

