/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.SlimeUtils;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.MetricsAggregator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ClusterMetricsRetriever {
    private static final Logger log = Logger.getLogger(ClusterMetricsRetriever.class.getName());
    private static final String VESPA_CONTAINER = "vespa.container";
    private static final String VESPA_QRSERVER = "vespa.qrserver";
    private static final String VESPA_DISTRIBUTOR = "vespa.distributor";
    private static final List<String> WANTED_METRIC_SERVICES = List.of("vespa.container", "vespa.qrserver", "vespa.distributor");

    public Map<ClusterInfo, MetricsAggregator> requestMetricsGroupedByCluster(Collection<URI> hosts) {
        ConcurrentHashMap<ClusterInfo, MetricsAggregator> clusterMetricsMap = new ConcurrentHashMap<ClusterInfo, MetricsAggregator>();
        Runnable retrieveMetricsJob = () -> hosts.parallelStream().forEach(host -> ClusterMetricsRetriever.getHostMetrics(host, clusterMetricsMap));
        ForkJoinPool threadPool = new ForkJoinPool(5);
        threadPool.submit(retrieveMetricsJob);
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return clusterMetricsMap;
    }

    private static void getHostMetrics(URI hostURI, Map<ClusterInfo, MetricsAggregator> clusterMetricsMap) {
        Slime responseBody = ClusterMetricsRetriever.doMetricsRequest(hostURI);
        Cursor parseError = responseBody.get().field("error_message");
        if (parseError.valid()) {
            log.info("Failed to retrieve metrics from " + hostURI + ": " + parseError.asString());
        }
        Cursor services = responseBody.get().field("services");
        services.traverse((i, servicesInspector) -> ClusterMetricsRetriever.parseService(servicesInspector, clusterMetricsMap));
    }

    private static Slime doMetricsRequest(URI hostURI) {
        HttpGet get = new HttpGet(hostURI);
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            InputStream is = response.getEntity().getContent();
            Slime slime = SlimeUtils.jsonToSlime((byte[])is.readAllBytes());
            is.close();
            return slime;
        }
        catch (IOException e) {
            log.warning("Was unable to fetch metrics from " + hostURI);
            return new Slime();
        }
    }

    private static void parseService(Inspector service, Map<ClusterInfo, MetricsAggregator> clusterMetricsMap) {
        String serviceName = service.field("name").asString();
        service.field("metrics").traverse((i, metric) -> ClusterMetricsRetriever.addMetricsToAggeregator(serviceName, metric, clusterMetricsMap));
    }

    private static void addMetricsToAggeregator(String serviceName, Inspector metric, Map<ClusterInfo, MetricsAggregator> clusterMetricsMap) {
        if (!WANTED_METRIC_SERVICES.contains(serviceName)) {
            return;
        }
        Inspector values = metric.field("values");
        ClusterInfo clusterInfo = ClusterMetricsRetriever.getClusterInfoFromDimensions(metric.field("dimensions"));
        MetricsAggregator metricsAggregator = clusterMetricsMap.computeIfAbsent(clusterInfo, c -> new MetricsAggregator());
        switch (serviceName) {
            case "vespa.container": {
                metricsAggregator.addContainerLatency(values.field("query_latency.sum").asDouble(), values.field("query_latency.count").asDouble());
                metricsAggregator.addFeedLatency(values.field("feed_latency.sum").asDouble(), values.field("feed_latency.count").asDouble());
                break;
            }
            case "vespa.qrserver": {
                metricsAggregator.addQrLatency(values.field("query_latency.sum").asDouble(), values.field("query_latency.count").asDouble());
                break;
            }
            case "vespa.distributor": {
                metricsAggregator.addDocumentCount(values.field("vds.distributor.docsstored.average").asDouble());
            }
        }
    }

    private static ClusterInfo getClusterInfoFromDimensions(Inspector dimensions) {
        return new ClusterInfo(dimensions.field("clusterid").asString(), dimensions.field("clustertype").asString());
    }
}

