/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.model;

import com.yahoo.cloud.config.RoutingConfig;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.Map;
import java.util.Set;

public class RoutingProducer
implements RoutingConfig.Producer {
    static final ApplicationName ROUTING_APPLICATION = ApplicationName.from((String)"routing");
    private final Map<TenantName, Set<ApplicationInfo>> models;

    public RoutingProducer(Map<TenantName, Set<ApplicationInfo>> models) {
        this.models = models;
    }

    public void getConfig(RoutingConfig.Builder builder) {
        for (Set<ApplicationInfo> model : this.models.values()) {
            model.stream().filter(application -> this.isHostedVespaRoutingApplication(application.getApplicationId())).forEach(application -> {
                for (HostInfo host : application.getModel().getHosts()) {
                    builder.hosts(host.getHostname());
                }
            });
        }
    }

    private boolean isHostedVespaRoutingApplication(ApplicationId applicationId) {
        return TenantRepository.HOSTED_VESPA_TENANT.equals((Object)applicationId.tenant()) && ROUTING_APPLICATION.equals((Object)applicationId.application());
    }
}

