/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.status;

import com.google.inject.Inject;
import com.yahoo.component.Version;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.SlimeUtils;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.JSONResponse;

public class StatusHandler
extends HttpHandler {
    private final GlobalComponentRegistry componentRegistry;

    @Inject
    public StatusHandler(LoggingRequestHandler.Context ctx, GlobalComponentRegistry componentRegistry) {
        super(ctx);
        this.componentRegistry = componentRegistry;
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        return new StatusResponse(200, this.componentRegistry);
    }

    private static class StatusResponse
    extends JSONResponse {
        StatusResponse(int status, GlobalComponentRegistry componentRegistry) {
            super(status);
            Cursor configCursor = this.object.setObject("configserverConfig");
            SlimeUtils.copyObject((Inspector)ConfigPayload.fromInstance((ConfigInstance)componentRegistry.getConfigserverConfig()).getSlime().get(), (Cursor)configCursor);
            Cursor modelVersionsCursor = this.object.setArray("modelVersions");
            componentRegistry.getModelFactoryRegistry().getFactories().stream().map(ModelFactory::version).map(Version::toFullString).forEach(arg_0 -> ((Cursor)modelVersionsCursor).addString(arg_0));
        }
    }
}

