/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.google.common.collect.ImmutableSet;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public class ZKTenantApplications
implements TenantApplications,
PathChildrenCacheListener {
    private static final Logger log = Logger.getLogger(ZKTenantApplications.class.getName());
    private final Curator curator;
    private final Path applicationsPath;
    private static final ExecutorService pathChildrenExecutor = Executors.newCachedThreadPool(ThreadFactoryFactory.getDaemonThreadFactory((String)ZKTenantApplications.class.getName()));
    private final Curator.DirectoryCache directoryCache;
    private final ReloadHandler reloadHandler;
    private final TenantName tenant;

    private ZKTenantApplications(Curator curator, Path applicationsPath, ReloadHandler reloadHandler, TenantName tenant) {
        this.curator = curator;
        this.applicationsPath = applicationsPath;
        curator.create(applicationsPath);
        this.reloadHandler = reloadHandler;
        this.tenant = tenant;
        this.directoryCache = curator.createDirectoryCache(applicationsPath.getAbsolute(), false, false, pathChildrenExecutor);
        this.directoryCache.start();
        this.directoryCache.addListener((PathChildrenCacheListener)this);
    }

    public static TenantApplications create(Curator curator, ReloadHandler reloadHandler, TenantName tenant) {
        try {
            return new ZKTenantApplications(curator, TenantRepository.getApplicationsPath(tenant), reloadHandler, tenant);
        }
        catch (Exception e) {
            throw new RuntimeException(TenantRepository.logPre(tenant) + "Error creating application repo", e);
        }
    }

    private long readSessionId(ApplicationId appId, String appNode) {
        String path = this.applicationsPath.append(appNode).getAbsolute();
        try {
            return Long.parseLong(Utf8.toString((byte[])((byte[])this.curator.framework().getData().forPath(path))));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(TenantRepository.logPre(appId) + "Unable to read the session id from '" + path + "'", e);
        }
    }

    @Override
    public List<ApplicationId> listApplications() {
        try {
            List appNodes = (List)this.curator.framework().getChildren().forPath(this.applicationsPath.getAbsolute());
            ArrayList<ApplicationId> applicationIds = new ArrayList<ApplicationId>();
            for (String appNode : appNodes) {
                this.parseApplication(appNode).ifPresent(applicationIds::add);
            }
            return applicationIds;
        }
        catch (Exception e) {
            throw new RuntimeException(TenantRepository.logPre(this.tenant) + "Unable to list applications", e);
        }
    }

    private Optional<ApplicationId> parseApplication(String appNode) {
        try {
            return Optional.of(ApplicationId.fromSerializedForm((String)appNode));
        }
        catch (IllegalArgumentException e) {
            log.log(LogLevel.INFO, TenantRepository.logPre(this.tenant) + "Unable to parse application with id '" + appNode + "', ignoring.");
            return Optional.empty();
        }
    }

    @Override
    public Transaction createPutApplicationTransaction(ApplicationId applicationId, long sessionId) {
        if (this.listApplications().contains(applicationId)) {
            return new CuratorTransaction(this.curator).add((Transaction.Operation)CuratorOperations.setData((String)this.applicationsPath.append(applicationId.serializedForm()).getAbsolute(), (byte[])Utf8.toAsciiBytes((long)sessionId)));
        }
        return new CuratorTransaction(this.curator).add((Transaction.Operation)CuratorOperations.create((String)this.applicationsPath.append(applicationId.serializedForm()).getAbsolute(), (byte[])Utf8.toAsciiBytes((long)sessionId)));
    }

    @Override
    public long getSessionIdForApplication(ApplicationId applicationId) {
        return this.readSessionId(applicationId, applicationId.serializedForm());
    }

    public CuratorTransaction deleteApplication(ApplicationId applicationId) {
        Path path = this.applicationsPath.append(applicationId.serializedForm());
        return CuratorTransaction.from((CuratorOperation)CuratorOperations.delete((String)path.getAbsolute()), (Curator)this.curator);
    }

    @Override
    public void close() {
        this.directoryCache.close();
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
        switch (event.getType()) {
            case CHILD_ADDED: {
                this.applicationAdded(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                break;
            }
            case CHILD_REMOVED: {
                this.applicationRemoved(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                break;
            }
            case CHILD_UPDATED: {
                break;
            }
        }
        this.removeUnusedApplications();
    }

    private void applicationRemoved(ApplicationId applicationId) {
        this.reloadHandler.removeApplication(applicationId);
        log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Application removed: " + applicationId);
    }

    private void applicationAdded(ApplicationId applicationId) {
        log.log((Level)LogLevel.DEBUG, TenantRepository.logPre(applicationId) + "Application added: " + applicationId);
    }

    @Override
    public void removeUnusedApplications() {
        ImmutableSet activeApplications = ImmutableSet.copyOf(this.listApplications());
        this.reloadHandler.removeApplicationsExcept((Set<ApplicationId>)activeApplications);
    }
}

