/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.rpc;

import com.yahoo.cloud.config.SentinelConfig;
import com.yahoo.component.Version;
import com.yahoo.config.provision.TenantName;
import com.yahoo.jrt.Request;
import com.yahoo.log.LogLevel;
import com.yahoo.net.HostName;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.UnknownConfigIdException;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.protocol.SlimeConfigResponse;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.server.GetConfigContext;
import com.yahoo.vespa.config.server.UnknownConfigDefinitionException;
import com.yahoo.vespa.config.server.rpc.RpcServer;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class GetConfigProcessor
implements Runnable {
    private static final Logger log = Logger.getLogger(GetConfigProcessor.class.getName());
    private static final String localHostName = HostName.getLocalhost();
    private final JRTServerConfigRequest request;
    private final boolean forceResponse;
    private final RpcServer rpcServer;
    private String logPre = "";

    GetConfigProcessor(RpcServer rpcServer, JRTServerConfigRequest request, boolean forceResponse) {
        this.rpcServer = rpcServer;
        this.request = request;
        this.forceResponse = forceResponse;
    }

    private void respond(JRTServerConfigRequest request) {
        Request req = request.getRequest();
        if (req.isError()) {
            Object logLevel = req.errorCode() == 100300 ? LogLevel.DEBUG : LogLevel.INFO;
            log.log((Level)logLevel, this.logPre + req.errorMessage());
        }
        this.rpcServer.respond(request);
    }

    private void handleError(JRTServerConfigRequest request, int errorCode, String message) {
        String target = "(unknown)";
        try {
            target = request.getRequest().target().toString();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        request.addErrorResponse(errorCode, this.logPre + "Failed request (" + message + ") from " + target);
        this.respond(request);
    }

    @Override
    public void run() {
        ConfigResponse config;
        Optional<Version> vespaVersion;
        if (!this.request.validateParameters()) {
            log.log(LogLevel.WARNING, "Parameters for request " + this.request + " did not validate: " + this.request.errorCode() + " : " + this.request.errorMessage());
            this.respond(this.request);
            return;
        }
        Trace trace = this.request.getRequestTrace();
        if (GetConfigProcessor.logDebug(trace)) {
            this.debugLog(trace, "GetConfigProcessor.run() on " + localHostName);
        }
        Optional<TenantName> tenant = this.rpcServer.resolveTenant(this.request, trace);
        if (this.rpcServer.isHostedVespa() && this.rpcServer.allTenantsLoaded() && !tenant.isPresent() && this.isSentinelConfigRequest(this.request)) {
            this.returnEmpty(this.request);
            return;
        }
        GetConfigContext context = this.rpcServer.createGetConfigContext(tenant, this.request, trace);
        if (context == null || !context.requestHandler().hasApplication(context.applicationId(), Optional.empty())) {
            this.handleError(this.request, 100300, "No application exists");
            return;
        }
        Optional<Version> optional = vespaVersion = this.rpcServer.useRequestVersion() ? this.request.getVespaVersion().map(VespaVersion::toString).map(Version::fromString) : Optional.empty();
        if (GetConfigProcessor.logDebug(trace)) {
            this.debugLog(trace, "Using version " + GetConfigProcessor.getPrintableVespaVersion(vespaVersion));
        }
        if (!context.requestHandler().hasApplication(context.applicationId(), vespaVersion)) {
            this.handleError(this.request, 100005, "Unknown Vespa version in request: " + GetConfigProcessor.getPrintableVespaVersion(vespaVersion));
            return;
        }
        this.logPre = TenantRepository.logPre(context.applicationId());
        try {
            config = this.rpcServer.resolveConfig(this.request, context, vespaVersion);
        }
        catch (UnknownConfigDefinitionException e) {
            this.handleError(this.request, 100001, "Unknown config definition " + this.request.getConfigKey());
            return;
        }
        catch (UnknownConfigIdException e) {
            this.handleError(this.request, 100102, "Illegal config id " + this.request.getConfigKey().getConfigId());
            return;
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Unexpected error handling config request", e);
            this.handleError(this.request, 100200, "Internal error " + e.getMessage());
            return;
        }
        if (config != null && (!config.hasEqualConfig(this.request) || config.hasNewerGeneration(this.request) || this.forceResponse)) {
            this.request.addOkResponse(this.request.payloadFromResponse(config), config.getGeneration(), config.isInternalRedeploy(), config.getConfigMd5());
            if (GetConfigProcessor.logDebug(trace)) {
                this.debugLog(trace, "return response: " + this.request.getShortDescription());
            }
            this.respond(this.request);
        } else {
            if (GetConfigProcessor.logDebug(trace)) {
                this.debugLog(trace, "delaying response " + this.request.getShortDescription());
            }
            this.rpcServer.delayResponse(this.request, context);
        }
    }

    private boolean isSentinelConfigRequest(JRTServerConfigRequest request) {
        return request.getConfigKey().getName().equals(SentinelConfig.getDefName()) && request.getConfigKey().getNamespace().equals(SentinelConfig.getDefNamespace());
    }

    private static String getPrintableVespaVersion(Optional<Version> vespaVersion) {
        return vespaVersion.isPresent() ? vespaVersion.get().toFullString() : "LATEST";
    }

    private void returnEmpty(JRTServerConfigRequest request) {
        ConfigPayload emptyPayload = ConfigPayload.empty();
        String configMd5 = ConfigUtils.getMd5((ConfigPayload)emptyPayload);
        SlimeConfigResponse config = SlimeConfigResponse.fromConfigPayload((ConfigPayload)emptyPayload, null, (long)0L, (boolean)false, (String)configMd5);
        request.addOkResponse(request.payloadFromResponse((ConfigResponse)config), config.getGeneration(), false, config.getConfigMd5());
        this.respond(request);
    }

    static boolean logDebug(Trace trace) {
        return trace.shouldTrace(9) || log.isLoggable((Level)LogLevel.DEBUG);
    }

    private void debugLog(Trace trace, String message) {
        if (GetConfigProcessor.logDebug(trace)) {
            log.log((Level)LogLevel.DEBUG, this.logPre + message);
            trace.trace(9, this.logPre + message);
        }
    }
}

