/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.serviceview;

import com.google.common.collect.ImmutableList;
import com.yahoo.text.Utf8;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class Service
implements Comparable<Service> {
    @NonNull
    public final String serviceType;
    @NonNull
    public final String host;
    public final int statePort;
    @NonNull
    public final String configId;
    @NonNull
    public final List<Integer> ports;
    @NonNull
    public final String name;

    public Service(String serviceType, String host, int statePort, String clusterName, String clusterType, String configId, List<Integer> ports, String name) {
        this.serviceType = serviceType;
        this.host = host.toLowerCase();
        this.statePort = statePort;
        this.configId = configId;
        ImmutableList.Builder portsBuilder = new ImmutableList.Builder();
        portsBuilder.addAll(ports);
        this.ports = portsBuilder.build();
        this.name = name;
    }

    @Override
    public int compareTo(Service other) {
        int serviceTypeOrder = this.serviceType.compareTo(other.serviceType);
        if (serviceTypeOrder != 0) {
            return serviceTypeOrder;
        }
        int hostOrder = this.host.compareTo(other.host);
        if (hostOrder != 0) {
            return hostOrder;
        }
        return Integer.compare(this.statePort, other.statePort);
    }

    public String getIdentifier(int port) {
        MessageDigest md5;
        StringBuilder b = new StringBuilder(this.serviceType);
        b.append("-");
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 should by definition always be available in the JVM.", e);
        }
        md5.update(Utf8.toBytes((String)this.serviceType));
        md5.update(Utf8.toBytes((String)this.configId));
        md5.update(Utf8.toBytes((String)this.host));
        for (int i = 3; i >= 0; --i) {
            md5.update((byte)(port >>> i));
        }
        byte[] digest = md5.digest();
        BigInteger digestMarshal = new BigInteger(1, digest);
        b.append(digestMarshal.toString(36));
        return b.toString();
    }

    public List<String> getIdentifiers() {
        ArrayList<String> ids = new ArrayList<String>(this.ports.size());
        for (int port : this.ports) {
            ids.add(this.getIdentifier(port));
        }
        return ids;
    }

    public int matchIdentifierWithPort(String identifier) {
        for (int port : this.ports) {
            if (!identifier.equals(this.getIdentifier(port))) continue;
            return port;
        }
        throw new IllegalArgumentException("Identifier " + identifier + " matches no ports in " + this);
    }

    public String toString() {
        int maxLen = 3;
        StringBuilder builder = new StringBuilder();
        builder.append("Service [serviceType=").append(this.serviceType).append(", host=").append(this.host).append(", statePort=").append(this.statePort).append(", configId=").append(this.configId).append(", ports=").append(this.ports.subList(0, Math.min(this.ports.size(), 3))).append(", name=").append(this.name).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 131;
        int result = 1;
        result = 131 * result + this.configId.hashCode();
        result = 131 * result + this.host.hashCode();
        result = 131 * result + this.name.hashCode();
        result = 131 * result + this.ports.hashCode();
        result = 131 * result + this.serviceType.hashCode();
        result = 131 * result + this.statePort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Service other = (Service)obj;
        if (!this.configId.equals(other.configId)) {
            return false;
        }
        if (!this.host.equals(other.host)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.ports.equals(other.ports)) {
            return false;
        }
        if (!this.serviceType.equals(other.serviceType)) {
            return false;
        }
        return this.statePort == other.statePort;
    }
}

