/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.transaction.AbstractTransaction;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.session.Session;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class SessionRepo<SESSIONTYPE extends Session> {
    private final HashMap<Long, SESSIONTYPE> sessions = new HashMap();

    public synchronized void addSession(SESSIONTYPE session) {
        if (this.sessions.containsKey(((Session)session).getSessionId())) {
            throw new IllegalArgumentException("There already exists a session with id '" + ((Session)session).getSessionId() + "'");
        }
        this.sessions.put(((Session)session).getSessionId(), session);
    }

    public synchronized SESSIONTYPE removeSession(long id) {
        if (!this.sessions.containsKey(id)) {
            throw new IllegalArgumentException("No session with id '" + id + "' exists");
        }
        return (SESSIONTYPE)((Session)this.sessions.remove(id));
    }

    public void removeSession(long id, NestedTransaction nestedTransaction) {
        SessionRepoTransaction transaction = new SessionRepoTransaction();
        transaction.addRemoveOperation(id);
        nestedTransaction.add((Transaction)transaction, new Class[0]);
    }

    public synchronized SESSIONTYPE getSession(long id) {
        return (SESSIONTYPE)((Session)this.sessions.get(id));
    }

    public synchronized SESSIONTYPE getSession(long id, long timeoutInMillis) {
        try {
            return this.internalGetSession(id, timeoutInMillis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while retrieving session with id " + id);
        }
    }

    private synchronized SESSIONTYPE internalGetSession(long id, long timeoutInMillis) throws InterruptedException {
        TimeoutBudget timeoutBudget = new TimeoutBudget(Clock.systemUTC(), Duration.ofMillis(timeoutInMillis));
        do {
            SESSIONTYPE session;
            if ((session = this.getSession(id)) != null) {
                return session;
            }
            this.wait(100L);
        } while (timeoutBudget.hasTimeLeft());
        throw new NotFoundException("Unable to retrieve session with id " + id + " before timeout was reached");
    }

    public synchronized Collection<SESSIONTYPE> listSessions() {
        return new ArrayList<SESSIONTYPE>(this.sessions.values());
    }

    public class SessionRepoTransaction
    extends AbstractTransaction {
        void addRemoveOperation(long sessionIdToRemove) {
            this.add(new RemoveOperation(sessionIdToRemove));
        }

        public void prepare() {
        }

        public void commit() {
            for (Transaction.Operation operation : this.operations()) {
                ((SessionOperation)operation).commit();
            }
        }

        public void rollbackOrLog() {
            for (Transaction.Operation operation : this.operations()) {
                ((SessionOperation)operation).rollback();
            }
        }

        /*
         * Signature claims super is com.yahoo.vespa.config.server.session.SessionRepo$SessionRepoTransaction.SessionOperation, not com.yahoo.vespa.config.server.session.SessionRepo$SessionRepoTransaction$SessionOperation - discarding signature.
         */
        public class RemoveOperation
        extends SessionOperation {
            private final long sessionIdToRemove;
            private SESSIONTYPE removed;

            RemoveOperation(long sessionIdToRemove) {
                this.removed = null;
                this.sessionIdToRemove = sessionIdToRemove;
            }

            @Override
            public void commit() {
                this.removed = SessionRepo.this.removeSession(this.sessionIdToRemove);
            }

            @Override
            public void rollback() {
                if (this.removed != null) {
                    SessionRepo.this.addSession(this.removed);
                }
            }
        }

        abstract class SessionOperation
        implements Transaction.Operation {
            SessionOperation() {
            }

            abstract void commit();

            abstract void rollback();
        }
    }
}

