/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.host;

import com.google.inject.Inject;
import com.yahoo.config.provision.HostLivenessTracker;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigRequestHostLivenessTracker
implements HostLivenessTracker {
    private final Clock clock;
    private final Map<String, Instant> lastRequestFromHost = new ConcurrentHashMap<String, Instant>();

    @Inject
    public ConfigRequestHostLivenessTracker() {
        this(Clock.systemUTC());
    }

    public ConfigRequestHostLivenessTracker(Clock clock) {
        this.clock = clock;
    }

    public void receivedRequestFrom(String hostname) {
        this.lastRequestFromHost.put(hostname, this.clock.instant());
    }

    public Optional<Instant> lastRequestFrom(String hostname) {
        return Optional.ofNullable(this.lastRequestFromHost.get(hostname));
    }
}

