/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.google.common.base.Splitter;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.server.ServerCache;
import com.yahoo.vespa.config.server.UserConfigDefinitionRepo;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.config.util.ConfigUtils;

public class ServerCacheLoader {
    private final ConfigDefinitionRepo repo;
    private final ConfigCurator configCurator;
    private final Path path;

    ServerCacheLoader(ConfigCurator configCurator, Path rootPath, ConfigDefinitionRepo builtinConfigDefinitions) {
        this.configCurator = configCurator;
        this.path = rootPath;
        this.repo = builtinConfigDefinitions;
    }

    public ServerCache loadCache() {
        return this.loadConfigDefinitions();
    }

    private ServerCache loadConfigDefinitions() {
        try {
            return new ServerCache(this.repo, this.createUserConfigDefinitionsRepo(this.path.append("/userdefconfigs").getAbsolute()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load user config definitions from " + this.path, e);
        }
    }

    private UserConfigDefinitionRepo createUserConfigDefinitionsRepo(String appPath) {
        UserConfigDefinitionRepo userConfigDefinitionRepo = new UserConfigDefinitionRepo();
        if (!this.configCurator.exists(appPath)) {
            return userConfigDefinitionRepo;
        }
        for (String nodeName : this.configCurator.getChildren(appPath)) {
            String payload = this.configCurator.getData(appPath, nodeName);
            ConfigDefinitionKey dKey = ConfigUtils.createConfigDefinitionKeyFromZKString((String)nodeName);
            userConfigDefinitionRepo.add(dKey, new ConfigDefinition(dKey.getName(), Splitter.on((String)"\n").splitToList((CharSequence)payload).toArray(new String[0])));
        }
        return userConfigDefinitionRepo;
    }
}

