/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.monitoring;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZKMetricUpdater
extends TimerTask {
    private static final Logger log = Logger.getLogger(ZKMetricUpdater.class.getName());
    public static final String METRIC_ZK_ZNODES = Metrics.getMetricName("zkZNodes");
    public static final String METRIC_ZK_LATENCY_AVERAGE = Metrics.getMetricName("zkAvgLatency");
    public static final String METRIC_ZK_LATENCY_MAX = Metrics.getMetricName("zkMaxLatency");
    public static final String METRIC_ZK_CONNECTIONS = Metrics.getMetricName("zkConnections");
    public static final String METRIC_ZK_OUTSTANDING_REQUESTS = Metrics.getMetricName("zkOutstandingRequests");
    private final int CONNECTION_TIMEOUT_MS = 500;
    private final int WRITE_TIMEOUT_MS = 250;
    private final int READ_TIMEOUT_MS = 500;
    private AtomicReference<Map<String, Long>> zkMetrics = new AtomicReference(new HashMap());
    private final Timer timer = new Timer();
    private final int zkPort;
    private static final Pattern MONITORING_REPORT = Pattern.compile("^(\\w+)\\s+(\\d+)$", 8);

    public ZKMetricUpdater(ZookeeperServerConfig zkServerConfig, long delay, long interval) {
        this.zkPort = zkServerConfig.clientPort();
        if (interval > 0L) {
            this.timer.scheduleAtFixedRate((TimerTask)this, delay, interval);
        }
    }

    private void setMetricAttribute(String attribute, long value, Map<String, Long> data) {
        switch (attribute) {
            case "zk_znode_count": {
                data.put(METRIC_ZK_ZNODES, value);
                break;
            }
            case "zk_avg_latency": {
                data.put(METRIC_ZK_LATENCY_AVERAGE, value);
                break;
            }
            case "zk_max_latency": {
                data.put(METRIC_ZK_LATENCY_MAX, value);
                break;
            }
            case "zk_num_alive_connections": {
                data.put(METRIC_ZK_CONNECTIONS, value);
                break;
            }
            case "zk_outstanding_requests": {
                data.put(METRIC_ZK_OUTSTANDING_REQUESTS, value);
            }
        }
    }

    @Override
    public void run() {
        Optional<String> report = this.retrieveReport();
        report.ifPresent(this::parseReport);
        this.timer.purge();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> retrieveReport() {
        try (AsynchronousSocketChannel chan = AsynchronousSocketChannel.open();){
            InetSocketAddress zkAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), this.zkPort);
            Future<Void> connected = chan.connect(zkAddress);
            connected.get(500L, TimeUnit.MILLISECONDS);
            Future<Integer> written = chan.write(ByteBuffer.wrap("mntr\n".getBytes(StandardCharsets.UTF_8)));
            written.get(250L, TimeUnit.MILLISECONDS);
            int nread = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            do {
                Future<Integer> read = chan.read(buffer);
                nread = read.get(500L, TimeUnit.MILLISECONDS);
                buffer.flip();
                baos.write(buffer.array());
                buffer.clear();
            } while (nread >= 0);
            Optional<String> optional = Optional.of(baos.toString("UTF-8"));
            return optional;
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            log.warning("Failure in retrieving monitoring data: (" + e.getClass().getName() + ") " + e.getMessage());
            return Optional.empty();
        }
    }

    private void parseReport(String report) {
        Matcher matcher = MONITORING_REPORT.matcher(report);
        HashMap<String, Long> data = new HashMap<String, Long>();
        while (matcher.find()) {
            String attribute = matcher.group(1);
            long value = Long.parseLong(matcher.group(2));
            this.setMetricAttribute(attribute, value, data);
        }
        this.zkMetrics.set(data);
    }

    public Map<String, Long> getZKMetrics() {
        return this.zkMetrics.get();
    }
}

