/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.config.provision.SystemName;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.FileDistributionMaintainer;
import com.yahoo.vespa.config.server.maintenance.SessionsMaintainer;
import com.yahoo.vespa.config.server.maintenance.TenantsMaintainer;
import com.yahoo.vespa.config.server.maintenance.ZooKeeperDataMaintainer;
import com.yahoo.vespa.config.server.session.FileDistributionFactory;
import com.yahoo.vespa.curator.Curator;
import java.time.Duration;

public class ConfigServerMaintenance
extends AbstractComponent {
    private final TenantsMaintainer tenantsMaintainer;
    private final ZooKeeperDataMaintainer zooKeeperDataMaintainer;
    private final FileDistributionMaintainer fileDistributionMaintainer;
    private final SessionsMaintainer sessionsMaintainer;

    public ConfigServerMaintenance(ConfigserverConfig configserverConfig, ApplicationRepository applicationRepository, Curator curator, FileDistributionFactory fileDistributionFactory) {
        DefaultTimes defaults = new DefaultTimes(configserverConfig);
        this.tenantsMaintainer = new TenantsMaintainer(applicationRepository, curator, defaults.tenantsMaintainerInterval);
        this.zooKeeperDataMaintainer = new ZooKeeperDataMaintainer(applicationRepository, curator, defaults.defaultInterval);
        this.fileDistributionMaintainer = new FileDistributionMaintainer(applicationRepository, curator, defaults.defaultInterval, configserverConfig);
        this.sessionsMaintainer = new SessionsMaintainer(applicationRepository, curator, defaults.defaultInterval);
    }

    public void deconstruct() {
        this.tenantsMaintainer.deconstruct();
        this.zooKeeperDataMaintainer.deconstruct();
        this.fileDistributionMaintainer.deconstruct();
        this.sessionsMaintainer.deconstruct();
    }

    private static class DefaultTimes {
        private final Duration defaultInterval;
        private final Duration tenantsMaintainerInterval;

        DefaultTimes(ConfigserverConfig configserverConfig) {
            this.defaultInterval = Duration.ofMinutes(configserverConfig.maintainerIntervalMinutes());
            boolean isCd = configserverConfig.system().equals(SystemName.cd.name());
            this.tenantsMaintainerInterval = isCd ? this.defaultInterval : Duration.ofMinutes(configserverConfig.tenantsMaintainerIntervalMinutes());
        }
    }
}

