/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.vespa.config.server.http.SessionResponse;
import java.io.IOException;
import java.io.OutputStream;

public class SessionContentStatusResponse
extends SessionResponse {
    private final ApplicationFile file;
    private final String urlBase;
    private final ApplicationFile.MetaData metaData;
    private final ObjectMapper mapper = new ObjectMapper();

    public SessionContentStatusResponse(ApplicationFile file, String urlBase) {
        this.file = file;
        this.urlBase = urlBase;
        ApplicationFile.MetaData metaData = file == null ? new ApplicationFile.MetaData("deleted", "") : file.getMetaData();
        if (metaData == null) {
            throw new IllegalArgumentException("Could not find status for '" + file.getPath() + "'");
        }
        this.metaData = metaData;
    }

    @Override
    public void render(OutputStream outputStream) throws IOException {
        this.mapper.writeValue(outputStream, (Object)new ResponseData(this.metaData.status, this.metaData.md5, this.urlBase + this.file.getPath()));
    }

    private static class ResponseData {
        public final String status;
        public final String md5;
        public final String name;

        private ResponseData(String status, String md5, String name) {
            this.status = status;
            this.md5 = md5;
            this.name = name;
        }
    }
}

