/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Maintainer
extends AbstractComponent
implements Runnable {
    protected static final Logger log = Logger.getLogger(Maintainer.class.getName());
    private static final Path root = Path.fromString((String)"/configserver/v1/");
    private static final Path lockRoot = root.append("locks");
    private final Duration maintenanceInterval;
    private final ScheduledExecutorService service;
    protected final ApplicationRepository applicationRepository;
    protected final Curator curator;

    Maintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval) {
        this.applicationRepository = applicationRepository;
        this.curator = curator;
        this.maintenanceInterval = interval;
        this.service = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory(this.name()));
        this.service.scheduleAtFixedRate(this, interval.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        try (Lock lock2 = this.lock(lockRoot.append(this.name()));){
            this.maintain();
        }
        catch (UncheckedTimeoutException lock2) {
        }
        catch (Throwable t) {
            log.log(Level.WARNING, this + " failed. Will retry in " + this.maintenanceInterval.toMinutes() + " minutes", t);
        }
    }

    private Lock lock(Path path) {
        Lock lock = new Lock(path.getAbsolute(), this.curator);
        lock.acquire(Duration.ofSeconds(1L));
        return lock;
    }

    public void deconstruct() {
        this.service.shutdown();
    }

    protected abstract void maintain();

    public String name() {
        return this.getClass().getSimpleName();
    }

    public final String toString() {
        return this.name();
    }
}

