/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.net.HostName;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.CompressedFileReference;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import com.yahoo.vespa.filedistribution.FileReferenceDataBlob;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.filedistribution.LazyFileReferenceData;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FileServer {
    private static final Logger log = Logger.getLogger(FileServer.class.getName());
    private final FileDirectory root;
    private final ExecutorService pushExecutor;
    private final ExecutorService pullExecutor;
    private final FileDownloader downloader;

    @Inject
    public FileServer(ConfigserverConfig configserverConfig) {
        this(FileServer.createConnectionPool(configserverConfig), new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir())));
    }

    public FileServer(File rootDir) {
        this(new EmptyConnectionPool(), rootDir);
    }

    private FileServer(ConnectionPool connectionPool, File rootDir) {
        this.downloader = new FileDownloader(connectionPool);
        this.root = new FileDirectory(rootDir);
        this.pushExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.pullExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    boolean hasFile(String fileReference) {
        return this.hasFile(new FileReference(fileReference));
    }

    private boolean hasFile(FileReference reference) {
        try {
            return this.root.getFile(reference).exists();
        }
        catch (IllegalArgumentException e) {
            log.log((Level)LogLevel.DEBUG, "Failed locating file reference '" + reference + "' with error " + e.toString());
            return false;
        }
    }

    void startFileServing(String fileName, Receiver target) {
        FileReference reference = new FileReference(fileName);
        File file = this.root.getFile(reference);
        if (file.exists()) {
            this.pushExecutor.execute(() -> this.serveFile(reference, target));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(FileReference reference, Receiver target) {
        File file = this.root.getFile(reference);
        log.log((Level)LogLevel.DEBUG, () -> "Start serving reference '" + reference.value() + "' with file '" + file.getAbsolutePath() + "'");
        boolean success = false;
        String errorDescription = "OK";
        FileReferenceData fileData = FileReferenceDataBlob.empty((FileReference)reference, (String)file.getName());
        try {
            fileData = this.readFileReferenceData(reference);
            success = true;
        }
        catch (IOException e) {
            errorDescription = "For file reference '" + reference.value() + "': failed reading file '" + file.getAbsolutePath() + "'";
            log.warning(errorDescription + " for sending to '" + target.toString() + "'. " + e.toString());
        }
        try {
            target.receive(fileData, new ReplayStatus(success ? 0 : 1, success ? "OK" : errorDescription));
            log.log((Level)LogLevel.DEBUG, "Done serving file reference '" + reference.value() + "' with file '" + file.getAbsolutePath() + "'");
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Failed serving file reference '" + reference.value() + "': " + Exceptions.toMessageString((Throwable)e));
        }
        finally {
            fileData.close();
        }
    }

    private FileReferenceData readFileReferenceData(FileReference reference) throws IOException {
        File file = this.root.getFile(reference);
        if (file.isDirectory()) {
            byte[] blob = CompressedFileReference.compress((File)file.getParentFile());
            return new FileReferenceDataBlob(reference, file.getName(), FileReferenceData.Type.compressed, blob);
        }
        return new LazyFileReferenceData(reference, file.getName(), FileReferenceData.Type.file, file);
    }

    public void serveFile(String fileReference, boolean downloadFromOtherSourceIfNotFound, Request request, Receiver receiver) {
        this.pullExecutor.execute(() -> this.serveFileInternal(fileReference, downloadFromOtherSourceIfNotFound, request, receiver));
    }

    private void serveFileInternal(String fileReference, boolean downloadFromOtherSourceIfNotFound, Request request, Receiver receiver) {
        boolean fileExists;
        log.log((Level)LogLevel.DEBUG, () -> "Received request for reference '" + fileReference + "' from " + request.target());
        try {
            boolean bl = fileExists = this.hasFile(fileReference) || this.download(fileReference, downloadFromOtherSourceIfNotFound);
            if (fileExists) {
                this.startFileServing(fileReference, receiver);
            }
        }
        catch (IllegalArgumentException e) {
            fileExists = false;
            log.warning("Failed serving file reference '" + fileReference + "', request was from " + request.target() + ", with error " + e.toString());
        }
        FileApiErrorCodes result = fileExists ? FileApiErrorCodes.OK : FileApiErrorCodes.NOT_FOUND;
        request.returnValues().add((Value)new Int32Value(result.getCode())).add((Value)new StringValue(result.getDescription()));
        request.returnRequest();
    }

    private boolean download(String fileReference, boolean downloadFromOtherSourceIfNotFound) {
        if (downloadFromOtherSourceIfNotFound) {
            log.log((Level)LogLevel.DEBUG, "File not found, downloading from another source");
            return this.download(fileReference).isPresent();
        }
        log.log((Level)LogLevel.DEBUG, "File not found, will not download from another source since request came from another config server");
        return false;
    }

    private Optional<File> download(String fileReference) {
        return this.downloader.getFile(new FileReferenceDownload(new FileReference(fileReference), false));
    }

    public FileDownloader downloader() {
        return this.downloader;
    }

    private static ConnectionPool createConnectionPool(ConfigserverConfig configserverConfig) {
        List configServers = ConfigServerSpec.fromConfig(configserverConfig).stream().filter(spec -> !spec.getHostName().equals(HostName.getLocalhost())).map(spec -> "tcp/" + spec.getHostName() + ":" + spec.getConfigServerPort()).collect(Collectors.toList());
        return configServers.size() > 0 ? new JRTConnectionPool(new ConfigSourceSet(configServers)) : new EmptyConnectionPool();
    }

    private static class EmptyConnectionPool
    implements ConnectionPool {
        private EmptyConnectionPool() {
        }

        public void close() {
        }

        public void setError(Connection connection, int i) {
        }

        public Connection getCurrent() {
            return null;
        }

        public Connection setNewCurrentConnection() {
            return null;
        }

        public int getSize() {
            return 0;
        }

        public Supervisor getSupervisor() {
            return new Supervisor(new Transport());
        }
    }

    public static interface Receiver {
        public void receive(FileReferenceData var1, ReplayStatus var2);
    }

    public static class ReplayStatus {
        private final int code;
        private final String description;

        ReplayStatus(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public boolean ok() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static enum FileApiErrorCodes {
        OK(0, "OK"),
        NOT_FOUND(1, "Filereference not found");

        private final int code;
        private final String description;

        private FileApiErrorCodes(int code, String description) {
            this.code = code;
            this.description = description;
        }

        int getCode() {
            return this.code;
        }

        String getDescription() {
            return this.description;
        }
    }
}

