/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.Maintainer;
import com.yahoo.vespa.curator.Curator;
import java.time.Duration;

public class SessionsMaintainer
extends Maintainer {
    private final boolean hostedVespa;

    SessionsMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval) {
        super(applicationRepository, curator, interval);
        this.hostedVespa = applicationRepository.configserverConfig().hostedVespa();
    }

    @Override
    protected void maintain() {
        this.applicationRepository.deleteExpiredLocalSessions();
        Duration expiryTime = Duration.ofDays(30L);
        if (this.hostedVespa) {
            this.applicationRepository.deleteExpiredRemoteSessions(expiryTime);
        }
    }
}

