/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.yahoo.collections.Tuple2;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.HttpConfigRequests;
import com.yahoo.vespa.config.server.http.v2.TenantRequest;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class HttpConfigRequest
implements GetConfigRequest,
TenantRequest {
    private static final String HTTP_PROPERTY_NOCACHE = "noCache";
    private final ConfigKey<?> key;
    private final ApplicationId appId;
    private final boolean noCache;

    private HttpConfigRequest(ConfigKey<?> key, ApplicationId appId, boolean noCache) {
        this.key = key;
        this.appId = appId;
        this.noCache = noCache;
    }

    private static ConfigKey<?> fromRequestV1(HttpRequest req) {
        BindingMatch<?> bm = Utils.getBindingMatch(req, "http://*/config/v1/*/*");
        String conf = bm.group(2);
        String cId = bm.groupCount() >= 4 ? bm.group(3) : "";
        Tuple2<String, String> nns = HttpConfigRequest.nameAndNamespace(conf);
        String cName = (String)nns.first;
        String cNamespace = (String)nns.second;
        return new ConfigKey(cName, cId, cNamespace);
    }

    public static HttpConfigRequest createFromRequestV1(HttpRequest req) {
        return new HttpConfigRequest(HttpConfigRequest.fromRequestV1(req), ApplicationId.defaultId(), req.getBooleanProperty(HTTP_PROPERTY_NOCACHE));
    }

    public static HttpConfigRequest createFromRequestV2(HttpRequest req) {
        BindingMatch<?> bm = HttpConfigRequests.getBindingMatch(req, "http://*/config/v2/tenant/*/application/*/environment/*/region/*/instance/*/*/*", "http://*/config/v2/tenant/*/application/*/*/*");
        if (bm.groupCount() > 6) {
            return HttpConfigRequest.createFromRequestV2FullAppId(req, bm);
        }
        return HttpConfigRequest.createFromRequestV2SimpleAppId(req, bm);
    }

    private static HttpConfigRequest createFromRequestV2SimpleAppId(HttpRequest req, BindingMatch<?> bm) {
        TenantName tenant = TenantName.from((String)bm.group(2));
        ApplicationName application = ApplicationName.from((String)bm.group(3));
        String conf = bm.group(4);
        String cId = bm.groupCount() >= 6 ? bm.group(5) : "";
        Tuple2<String, String> nns = HttpConfigRequest.nameAndNamespace(conf);
        String cName = (String)nns.first;
        String cNamespace = (String)nns.second;
        return new HttpConfigRequest(new ConfigKey(cName, cId, cNamespace), new ApplicationId.Builder().applicationName(application).tenant(tenant).build(), req.getBooleanProperty(HTTP_PROPERTY_NOCACHE));
    }

    private static HttpConfigRequest createFromRequestV2FullAppId(HttpRequest req, BindingMatch<?> bm) {
        String tenant = bm.group(2);
        String application = bm.group(3);
        String environment = bm.group(4);
        String region = bm.group(5);
        String instance = bm.group(6);
        String conf = bm.group(7);
        String cId = bm.groupCount() >= 9 ? bm.group(8) : "";
        Tuple2<String, String> nns = HttpConfigRequest.nameAndNamespace(conf);
        String cName = (String)nns.first;
        String cNamespace = (String)nns.second;
        ApplicationId appId = new ApplicationId.Builder().tenant(tenant).applicationName(application).instanceName(instance).build();
        return new HttpConfigRequest(new ConfigKey(cName, cId, cNamespace), appId, req.getBooleanProperty(HTTP_PROPERTY_NOCACHE));
    }

    public static void validateRequestKey(ConfigKey<?> requestKey, RequestHandler requestHandler, ApplicationId appId) {
        Set<ConfigKey<?>> allConfigsProduced = requestHandler.allConfigsProduced(appId, Optional.empty());
        if (allConfigsProduced.isEmpty()) {
            HttpConfigRequest.throwModelNotReady();
        }
        if (HttpConfigRequest.configNameNotFound(requestKey, allConfigsProduced)) {
            throw new NotFoundException("No such config: " + requestKey.getNamespace() + "." + requestKey.getName());
        }
        if (HttpConfigRequest.configIdNotFound(requestHandler, requestKey, appId)) {
            throw new NotFoundException("No such config id: " + requestKey.getConfigId());
        }
    }

    public static void throwModelNotReady() {
        throw new NotFoundException("Config not available, verify that an application package has been deployed and activated.");
    }

    private static boolean configNameNotFound(final ConfigKey<?> requestKey, Set<ConfigKey<?>> allConfigsProduced) {
        return !Iterables.any(allConfigsProduced, (Predicate)new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> k) {
                return k.getName().equals(requestKey.getName()) && k.getNamespace().equals(requestKey.getNamespace());
            }
        });
    }

    private static boolean configIdNotFound(RequestHandler requestHandler, ConfigKey<?> requestKey, ApplicationId appId) {
        return !requestHandler.allConfigIds(appId, Optional.empty()).contains(requestKey.getConfigId());
    }

    public static Tuple2<String, String> nameAndNamespace(String nsDotName) {
        Tuple2 ret = ConfigUtils.getNameAndNamespaceFromString((String)nsDotName);
        if ("".equals(ret.second)) {
            throw new IllegalArgumentException("Illegal config, must be of form namespace.name.");
        }
        return ret;
    }

    public ConfigKey<?> getConfigKey() {
        return this.key;
    }

    public DefContent getDefContent() {
        return DefContent.fromList(Collections.emptyList());
    }

    public Optional<VespaVersion> getVespaVersion() {
        return Optional.empty();
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public boolean noCache() {
        return this.noCache;
    }
}

