/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Deployer;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.io.IOUtils;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.slime.Slime;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.application.FileDistributionStatus;
import com.yahoo.vespa.config.server.application.HttpProxy;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RefeedActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.deploy.DeployHandlerLogger;
import com.yahoo.vespa.config.server.deploy.Deployment;
import com.yahoo.vespa.config.server.http.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.http.SimpleHttpFetcher;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.LocalSessionRepo;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.RemoteSessionRepo;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionFactory;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.Rotations;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ApplicationRepository
implements Deployer {
    private static final Logger log = Logger.getLogger(ApplicationRepository.class.getName());
    private final TenantRepository tenantRepository;
    private final Optional<Provisioner> hostProvisioner;
    private final ConfigConvergenceChecker convergeChecker;
    private final HttpProxy httpProxy;
    private final Clock clock;
    private final DeployLogger logger = new SilentDeployLogger();
    private final ConfigserverConfig configserverConfig;
    private final FileDistributionStatus fileDistributionStatus;

    @Inject
    public ApplicationRepository(TenantRepository tenantRepository, HostProvisionerProvider hostProvisionerProvider, ConfigConvergenceChecker configConvergenceChecker, HttpProxy httpProxy, ConfigserverConfig configserverConfig) {
        this(tenantRepository, hostProvisionerProvider.getHostProvisioner(), configConvergenceChecker, httpProxy, configserverConfig, Clock.systemUTC(), new FileDistributionStatus());
    }

    public ApplicationRepository(TenantRepository tenantRepository, Provisioner hostProvisioner, Clock clock) {
        this(tenantRepository, hostProvisioner, clock, new ConfigserverConfig(new ConfigserverConfig.Builder()));
    }

    public ApplicationRepository(TenantRepository tenantRepository, Provisioner hostProvisioner, Clock clock, ConfigserverConfig configserverConfig) {
        this(tenantRepository, Optional.of(hostProvisioner), new ConfigConvergenceChecker(), new HttpProxy(new SimpleHttpFetcher()), configserverConfig, clock, new FileDistributionStatus());
    }

    private ApplicationRepository(TenantRepository tenantRepository, Optional<Provisioner> hostProvisioner, ConfigConvergenceChecker configConvergenceChecker, HttpProxy httpProxy, ConfigserverConfig configserverConfig, Clock clock, FileDistributionStatus fileDistributionStatus) {
        this.tenantRepository = tenantRepository;
        this.hostProvisioner = hostProvisioner;
        this.convergeChecker = configConvergenceChecker;
        this.httpProxy = httpProxy;
        this.clock = clock;
        this.configserverConfig = configserverConfig;
        this.fileDistributionStatus = fileDistributionStatus;
    }

    public PrepareResult prepare(Tenant tenant, long sessionId, PrepareParams prepareParams, Instant now) {
        this.validateThatLocalSessionIsNotActive(tenant, sessionId);
        LocalSession session = this.getLocalSession(tenant, sessionId);
        ApplicationId applicationId = prepareParams.getApplicationId();
        Optional<ApplicationSet> currentActiveApplicationSet = this.getCurrentActiveApplicationSet(tenant, applicationId);
        Slime deployLog = this.createDeployLog();
        DeployHandlerLogger logger = new DeployHandlerLogger(deployLog.get().setArray("log"), prepareParams.isVerbose(), applicationId);
        ConfigChangeActions actions = session.prepare(logger, prepareParams, currentActiveApplicationSet, tenant.getPath(), now);
        ApplicationRepository.logConfigChangeActions(actions, logger);
        log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Session " + sessionId + " prepared successfully. ");
        return new PrepareResult(sessionId, actions, deployLog);
    }

    public PrepareResult prepareAndActivate(Tenant tenant, long sessionId, PrepareParams prepareParams, boolean ignoreLockFailure, boolean ignoreSessionStaleFailure, Instant now) {
        PrepareResult result = this.prepare(tenant, sessionId, prepareParams, now);
        this.activate(tenant, sessionId, prepareParams.getTimeoutBudget(), ignoreLockFailure, ignoreSessionStaleFailure);
        return result;
    }

    public PrepareResult deploy(CompressedApplicationInputStream in, PrepareParams prepareParams) {
        return this.deploy(in, prepareParams, false, false, this.clock.instant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrepareResult deploy(CompressedApplicationInputStream in, PrepareParams prepareParams, boolean ignoreLockFailure, boolean ignoreSessionStaleFailure, Instant now) {
        PrepareResult prepareResult;
        File tempDir = com.google.common.io.Files.createTempDir();
        try {
            prepareResult = this.deploy(this.decompressApplication(in, tempDir), prepareParams, ignoreLockFailure, ignoreSessionStaleFailure, now);
        }
        finally {
            this.cleanupTempDirectory(tempDir);
        }
        return prepareResult;
    }

    public PrepareResult deploy(File applicationPackage, PrepareParams prepareParams) {
        return this.deploy(applicationPackage, prepareParams, false, false, Instant.now());
    }

    public PrepareResult deploy(File applicationPackage, PrepareParams prepareParams, boolean ignoreLockFailure, boolean ignoreSessionStaleFailure, Instant now) {
        ApplicationId applicationId = prepareParams.getApplicationId();
        long sessionId = this.createSession(applicationId, prepareParams.getTimeoutBudget(), applicationPackage);
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        return this.prepareAndActivate(tenant, sessionId, prepareParams, ignoreLockFailure, ignoreSessionStaleFailure, now);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application) {
        return this.deployFromLocalActive(application, false);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application, boolean bootstrap) {
        return this.deployFromLocalActive(application, Duration.ofSeconds(this.configserverConfig.zookeeper().barrierTimeout()).plus(Duration.ofSeconds(5L)), bootstrap);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application, Duration timeout, boolean bootstrap) {
        Tenant tenant = this.tenantRepository.getTenant(application.tenant());
        if (tenant == null) {
            return Optional.empty();
        }
        LocalSession activeSession = this.getActiveSession(tenant, application);
        if (activeSession == null) {
            return Optional.empty();
        }
        TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, timeout);
        LocalSession newSession = tenant.getSessionFactory().createSessionFromExisting(activeSession, this.logger, true, timeoutBudget);
        tenant.getLocalSessionRepo().addSession(newSession);
        Version version = ApplicationRepository.decideVersion(application, this.zone().environment(), newSession.getVespaVersion(), bootstrap);
        return Optional.of(Deployment.unprepared(newSession, this, this.hostProvisioner, tenant, timeout, this.clock, false, version, bootstrap));
    }

    public Optional<Instant> lastDeployTime(ApplicationId application) {
        Tenant tenant = this.tenantRepository.getTenant(application.tenant());
        if (tenant == null) {
            return Optional.empty();
        }
        LocalSession activeSession = this.getActiveSession(tenant, application);
        if (activeSession == null) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochSecond(activeSession.getCreateTime()));
    }

    public ApplicationId activate(Tenant tenant, long sessionId, TimeoutBudget timeoutBudget, boolean ignoreLockFailure, boolean ignoreSessionStaleFailure) {
        LocalSession localSession = this.getLocalSession(tenant, sessionId);
        Deployment deployment = this.deployFromPreparedSession(localSession, tenant, timeoutBudget.timeLeft());
        deployment.setIgnoreLockFailure(ignoreLockFailure);
        deployment.setIgnoreSessionStaleFailure(ignoreSessionStaleFailure);
        deployment.activate();
        return localSession.getApplicationId();
    }

    private Deployment deployFromPreparedSession(LocalSession session, Tenant tenant, Duration timeout) {
        return Deployment.prepared(session, this, this.hostProvisioner, tenant, timeout, this.clock, false);
    }

    public boolean delete(ApplicationId applicationId) {
        boolean useDeleteApplicationLegacyInThisZone;
        List<String> hostedZonesToUseDeleteApplication = Arrays.asList("dev.us-east-1", "dev.corp-us-east-1", "test.us-east-1", "prod.corp-us-east-1", "prod.aws-us-east-1a", "prod.aws-us-west-1b");
        boolean bl = useDeleteApplicationLegacyInThisZone = !hostedZonesToUseDeleteApplication.contains(this.zone().toString());
        if (this.configserverConfig.deleteApplicationLegacy() || this.configserverConfig.hostedVespa() && this.zone().system() == SystemName.main && useDeleteApplicationLegacyInThisZone) {
            return this.deleteApplicationLegacy(applicationId);
        }
        return this.deleteApplication(applicationId);
    }

    boolean deleteApplication(ApplicationId applicationId) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        if (tenant == null) {
            return false;
        }
        TenantApplications tenantApplications = tenant.getApplicationRepo();
        if (!tenantApplications.listApplications().contains(applicationId)) {
            return false;
        }
        long sessionId = tenantApplications.getSessionIdForApplication(applicationId);
        RemoteSession remoteSession = this.getRemoteSession(tenant, sessionId);
        remoteSession.createDeleteTransaction().commit();
        log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Waiting for session " + sessionId + " to be deleted");
        Duration waitTime = Duration.ofSeconds(60L);
        if (!this.localSessionHasBeenDeleted(applicationId, sessionId, waitTime)) {
            log.log((Level)LogLevel.ERROR, TenantRepository.logPre(applicationId) + "Session " + sessionId + " was not deleted (waited " + waitTime + ")");
            return false;
        }
        log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Session " + sessionId + " deleted");
        NestedTransaction transaction = new NestedTransaction();
        transaction.add((Transaction)new Rotations(tenant.getCurator(), tenant.getPath()).delete(applicationId), new Class[0]);
        transaction.add(tenantApplications.deleteApplication(applicationId), new Class[0]);
        this.hostProvisioner.ifPresent(provisioner -> provisioner.remove(transaction, applicationId));
        transaction.onCommitted(() -> log.log(LogLevel.INFO, "Deleted " + applicationId));
        transaction.commit();
        return true;
    }

    boolean deleteApplicationLegacy(ApplicationId applicationId) {
        Optional<Tenant> owner = Optional.ofNullable(this.tenantRepository.getTenant(applicationId.tenant()));
        if (!owner.isPresent()) {
            return false;
        }
        TenantApplications tenantApplications = owner.get().getApplicationRepo();
        if (!tenantApplications.listApplications().contains(applicationId)) {
            return false;
        }
        long sessionId = tenantApplications.getSessionIdForApplication(applicationId);
        LocalSessionRepo localSessionRepo = owner.get().getLocalSessionRepo();
        LocalSession session = (LocalSession)localSessionRepo.getSession(sessionId);
        if (session == null) {
            return false;
        }
        NestedTransaction transaction = new NestedTransaction();
        localSessionRepo.removeSession(session.getSessionId(), transaction);
        session.delete(transaction);
        transaction.add((Transaction)new Rotations(owner.get().getCurator(), owner.get().getPath()).delete(applicationId), new Class[0]);
        transaction.add(tenantApplications.deleteApplication(applicationId), new Class[0]);
        this.hostProvisioner.ifPresent(provisioner -> provisioner.remove(transaction, applicationId));
        transaction.onCommitted(() -> log.log(LogLevel.INFO, "Deleted " + applicationId));
        transaction.commit();
        return true;
    }

    public HttpResponse clusterControllerStatusPage(ApplicationId applicationId, String hostName, String pathSuffix) {
        String relativePath = "clustercontroller-status/" + pathSuffix;
        return this.httpProxy.get(this.getApplication(applicationId), hostName, "container-clustercontroller", relativePath);
    }

    public Long getApplicationGeneration(ApplicationId applicationId) {
        return this.getApplication(applicationId).getApplicationGeneration();
    }

    public void restart(ApplicationId applicationId, HostFilter hostFilter) {
        this.hostProvisioner.ifPresent(provisioner -> provisioner.restart(applicationId, hostFilter));
    }

    public HttpResponse filedistributionStatus(ApplicationId applicationId, Duration timeout) {
        return this.fileDistributionStatus.status(this.getApplication(applicationId), timeout);
    }

    public Set<String> deleteUnusedFiledistributionReferences(File fileReferencesPath, boolean deleteFromDisk) {
        if (!fileReferencesPath.isDirectory()) {
            throw new RuntimeException(fileReferencesPath + " is not a directory");
        }
        HashSet fileReferencesInUse = new HashSet();
        Set<ApplicationId> applicationIds = this.listApplications();
        applicationIds.forEach(applicationId -> fileReferencesInUse.addAll(this.getApplication((ApplicationId)applicationId).getModel().fileReferences().stream().map(FileReference::value).collect(Collectors.toSet())));
        log.log((Level)LogLevel.DEBUG, "File references in use : " + fileReferencesInUse);
        HashSet fileReferencesOnDisk = new HashSet();
        File[] filesOnDisk = fileReferencesPath.listFiles();
        if (filesOnDisk != null) {
            fileReferencesOnDisk.addAll(Arrays.stream(filesOnDisk).map(File::getName).collect(Collectors.toSet()));
        }
        log.log((Level)LogLevel.DEBUG, "File references on disk (in " + fileReferencesPath + "): " + fileReferencesOnDisk);
        Instant instant = Instant.now().minus(Duration.ofDays(14L));
        Set<String> fileReferencesToDelete = fileReferencesOnDisk.stream().filter(fileReference -> !fileReferencesInUse.contains(fileReference)).filter(fileReference -> this.isFileLastModifiedBefore(new File(fileReferencesPath, (String)fileReference), instant)).collect(Collectors.toSet());
        if (deleteFromDisk && fileReferencesToDelete.size() > 0) {
            log.log(LogLevel.INFO, "Will delete file references not in use: " + fileReferencesToDelete);
            fileReferencesToDelete.forEach(fileReference -> {
                File file = new File(fileReferencesPath, (String)fileReference);
                if (!IOUtils.recursiveDeleteDir((File)file)) {
                    log.log(LogLevel.WARNING, "Could not delete " + file.getAbsolutePath());
                }
            });
        }
        return fileReferencesToDelete;
    }

    public ApplicationFile getApplicationFileFromSession(TenantName tenantName, long sessionId, String path, LocalSession.Mode mode) {
        Tenant tenant = this.tenantRepository.getTenant(tenantName);
        return this.getLocalSession(tenant, sessionId).getApplicationFile(Path.fromString((String)path), mode);
    }

    private Application getApplication(ApplicationId applicationId) {
        try {
            Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
            long sessionId = this.getSessionIdForApplication(tenant, applicationId);
            RemoteSession session = (RemoteSession)tenant.getRemoteSessionRepo().getSession(sessionId, 0L);
            return session.ensureApplicationLoaded().getForVersionOrLatest(Optional.empty(), this.clock.instant());
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Failed getting application for '" + applicationId + "'", e);
            throw e;
        }
    }

    private Set<ApplicationId> listApplications() {
        return this.tenantRepository.getAllTenants().stream().flatMap(tenant -> tenant.getApplicationRepo().listApplications().stream()).collect(Collectors.toSet());
    }

    private boolean isFileLastModifiedBefore(File fileReference, Instant instant) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(fileReference.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.lastModifiedTime().toInstant().isBefore(instant);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean localSessionHasBeenDeleted(ApplicationId applicationId, long sessionId, Duration waitTime) {
        RemoteSessionRepo remoteSessionRepo = this.tenantRepository.getTenant(applicationId.tenant()).getRemoteSessionRepo();
        Instant end = Instant.now().plus(waitTime);
        do {
            if (remoteSessionRepo.getSession(sessionId) == null) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Instant.now().isBefore(end));
        return false;
    }

    public HttpResponse checkServiceForConfigConvergence(ApplicationId applicationId, String hostAndPort, URI uri, Duration timeout) {
        return this.convergeChecker.checkService(this.getApplication(applicationId), hostAndPort, uri, timeout);
    }

    public HttpResponse servicesToCheckForConfigConvergence(ApplicationId applicationId, URI uri, Duration timeout) {
        return this.convergeChecker.servicesToCheck(this.getApplication(applicationId), uri, timeout);
    }

    public LocalSession getActiveSession(ApplicationId applicationId) {
        return this.getActiveSession(this.tenantRepository.getTenant(applicationId.tenant()), applicationId);
    }

    public long getSessionIdForApplication(Tenant tenant, ApplicationId applicationId) {
        return tenant.getApplicationRepo().getSessionIdForApplication(applicationId);
    }

    public void validateThatRemoteSessionIsNotActive(Tenant tenant, long sessionId) {
        RemoteSession session = this.getRemoteSession(tenant, sessionId);
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session is active: " + sessionId);
        }
    }

    public void validateThatRemoteSessionIsPrepared(Tenant tenant, long sessionId) {
        RemoteSession session = this.getRemoteSession(tenant, sessionId);
        if (!Session.Status.PREPARE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session not prepared: " + sessionId);
        }
    }

    public long createSessionFromExisting(ApplicationId applicationId, DeployLogger logger, boolean internalRedeploy, TimeoutBudget timeoutBudget) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        LocalSessionRepo localSessionRepo = tenant.getLocalSessionRepo();
        SessionFactory sessionFactory = tenant.getSessionFactory();
        LocalSession fromSession = this.getExistingSession(tenant, applicationId);
        LocalSession session = sessionFactory.createSessionFromExisting(fromSession, logger, internalRedeploy, timeoutBudget);
        localSessionRepo.addSession(session);
        return session.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSession(ApplicationId applicationId, TimeoutBudget timeoutBudget, InputStream in, String contentType) {
        long sessionId;
        File tempDir = com.google.common.io.Files.createTempDir();
        try {
            sessionId = this.createSession(applicationId, timeoutBudget, this.decompressApplication(in, contentType, tempDir));
        }
        finally {
            this.cleanupTempDirectory(tempDir);
        }
        return sessionId;
    }

    public long createSession(ApplicationId applicationId, TimeoutBudget timeoutBudget, File applicationDirectory) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        LocalSessionRepo localSessionRepo = tenant.getLocalSessionRepo();
        SessionFactory sessionFactory = tenant.getSessionFactory();
        LocalSession session = sessionFactory.createSession(applicationDirectory, applicationId, timeoutBudget);
        localSessionRepo.addSession(session);
        return session.getSessionId();
    }

    public void deleteExpiredLocalSessions() {
        this.listApplications().forEach(app -> this.tenantRepository.getTenant(app.tenant()).getLocalSessionRepo().purgeOldSessions());
    }

    public int deleteExpiredRemoteSessions(Duration expiryTime) {
        return this.listApplications().stream().map(app -> this.tenantRepository.getTenant(app.tenant()).getRemoteSessionRepo().deleteExpiredSessions(expiryTime, this.zone().system() == SystemName.cd)).mapToInt(i -> i).sum();
    }

    public Set<TenantName> deleteUnusedTenants(Duration ttlForUnusedTenant, Instant now) {
        return this.tenantRepository.getAllTenantNames().stream().filter(tenantName -> this.activeApplications((TenantName)tenantName).isEmpty()).filter(tenantName -> !tenantName.equals((Object)TenantName.defaultName())).filter(tenantName -> !tenantName.equals((Object)TenantRepository.HOSTED_VESPA_TENANT)).filter(tenantName -> this.tenantRepository.getTenant((TenantName)tenantName).getCreatedTime().isBefore(now.minus(ttlForUnusedTenant))).peek(this.tenantRepository::deleteTenant).collect(Collectors.toSet());
    }

    public void deleteTenant(TenantName tenantName) {
        List<ApplicationId> activeApplications = this.activeApplications(tenantName);
        if (!activeApplications.isEmpty()) {
            throw new IllegalArgumentException("Cannot delete tenant '" + tenantName + "', it has active applications: " + activeApplications);
        }
        this.tenantRepository.deleteTenant(tenantName);
    }

    private List<ApplicationId> activeApplications(TenantName tenantName) {
        return this.tenantRepository.getTenant(tenantName).getApplicationRepo().listApplications();
    }

    public Tenant verifyTenantAndApplication(ApplicationId applicationId) {
        TenantName tenantName = applicationId.tenant();
        if (!this.tenantRepository.checkThatTenantExists(tenantName)) {
            throw new IllegalArgumentException("Tenant " + tenantName + " was not found.");
        }
        Tenant tenant = this.tenantRepository.getTenant(tenantName);
        List<ApplicationId> applicationIds = this.listApplicationIds(tenant);
        if (!applicationIds.contains(applicationId)) {
            throw new IllegalArgumentException("No such application id: " + applicationId);
        }
        return tenant;
    }

    public ApplicationMetaData getMetadataFromSession(Tenant tenant, long sessionId) {
        return this.getLocalSession(tenant, sessionId).getMetaData();
    }

    public ConfigserverConfig configserverConfig() {
        return this.configserverConfig;
    }

    private void validateThatLocalSessionIsNotActive(Tenant tenant, long sessionId) {
        LocalSession session = this.getLocalSession(tenant, sessionId);
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session is active: " + sessionId);
        }
    }

    private LocalSession getLocalSession(Tenant tenant, long sessionId) {
        LocalSession session = (LocalSession)tenant.getLocalSessionRepo().getSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Session " + sessionId + " was not found");
        }
        return session;
    }

    private RemoteSession getRemoteSession(Tenant tenant, long sessionId) {
        RemoteSession session = (RemoteSession)tenant.getRemoteSessionRepo().getSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Session " + sessionId + " was not found");
        }
        return session;
    }

    private Optional<ApplicationSet> getCurrentActiveApplicationSet(Tenant tenant, ApplicationId appId) {
        Optional<ApplicationSet> currentActiveApplicationSet = Optional.empty();
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        try {
            long currentActiveSessionId = applicationRepo.getSessionIdForApplication(appId);
            RemoteSession currentActiveSession = this.getRemoteSession(tenant, currentActiveSessionId);
            if (currentActiveSession != null) {
                currentActiveApplicationSet = Optional.ofNullable(currentActiveSession.ensureApplicationLoaded());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return currentActiveApplicationSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File decompressApplication(InputStream in, String contentType, File tempDir) {
        try (CompressedApplicationInputStream application = CompressedApplicationInputStream.createFromCompressedStream(in, contentType);){
            File file = this.decompressApplication(application, tempDir);
            return file;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to decompress data in body", e);
        }
    }

    private File decompressApplication(CompressedApplicationInputStream in, File tempDir) {
        try {
            return in.decompress(tempDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to decompress stream", e);
        }
    }

    private List<ApplicationId> listApplicationIds(Tenant tenant) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        return applicationRepo.listApplications();
    }

    private void cleanupTempDirectory(File tempDir) {
        this.logger.log((Level)LogLevel.DEBUG, "Deleting tmp dir '" + tempDir + "'");
        if (!IOUtils.recursiveDeleteDir((File)tempDir)) {
            this.logger.log(LogLevel.WARNING, "Not able to delete tmp dir '" + tempDir + "'");
        }
    }

    boolean redeployAllApplications(Duration maxDuration, Duration sleepBetweenRetries) throws InterruptedException {
        Instant end = Instant.now().plus(maxDuration);
        Set<ApplicationId> applicationsNotRedeployed = this.listApplications();
        do {
            if ((applicationsNotRedeployed = this.redeployApplications(applicationsNotRedeployed)).isEmpty()) continue;
            Thread.sleep(sleepBetweenRetries.toMillis());
        } while (!applicationsNotRedeployed.isEmpty() && Instant.now().isBefore(end));
        if (!applicationsNotRedeployed.isEmpty()) {
            log.log((Level)LogLevel.ERROR, "Redeploying applications not finished after " + maxDuration + ", exiting, applications that failed redeployment: " + applicationsNotRedeployed);
            return false;
        }
        return true;
    }

    private Set<ApplicationId> redeployApplications(Set<ApplicationId> applicationIds) throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(this.configserverConfig.numParallelTenantLoaders(), (ThreadFactory)new DaemonThreadFactory("redeploy apps"));
        HashMap futures = new HashMap();
        HashSet<ApplicationId> failedDeployments = new HashSet<ApplicationId>();
        for (ApplicationId applicationId : applicationIds) {
            Optional<com.yahoo.config.provision.Deployment> deploymentOptional = this.deployFromLocalActive(applicationId, true);
            if (!deploymentOptional.isPresent()) continue;
            futures.put(applicationId, executor.submit(() -> ((com.yahoo.config.provision.Deployment)deploymentOptional.get()).activate()));
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ((Future)entry.getValue()).get();
            }
            catch (ExecutionException e) {
                ApplicationId app = (ApplicationId)entry.getKey();
                log.log(LogLevel.WARNING, "Redeploying " + app + " failed, will retry", e);
                failedDeployments.add(app);
            }
        }
        executor.shutdown();
        executor.awaitTermination(365L, TimeUnit.DAYS);
        return failedDeployments;
    }

    private LocalSession getExistingSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        return this.getLocalSession(tenant, applicationRepo.getSessionIdForApplication(applicationId));
    }

    private LocalSession getActiveSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (applicationRepo.listApplications().contains(applicationId)) {
            return (LocalSession)tenant.getLocalSessionRepo().getSession(applicationRepo.getSessionIdForApplication(applicationId));
        }
        return null;
    }

    private static void logConfigChangeActions(ConfigChangeActions actions, DeployLogger logger) {
        RefeedActions refeedActions;
        RestartActions restartActions = actions.getRestartActions();
        if (!restartActions.isEmpty()) {
            logger.log(Level.WARNING, "Change(s) between active and new application that require restart:\n" + restartActions.format());
        }
        if (!(refeedActions = actions.getRefeedActions()).isEmpty()) {
            boolean allAllowed = refeedActions.getEntries().stream().allMatch(RefeedActions.Entry::allowed);
            logger.log(allAllowed ? Level.INFO : Level.WARNING, "Change(s) between active and new application that may require re-feed:\n" + refeedActions.format());
        }
    }

    static Version decideVersion(ApplicationId application, Environment environment, Version targetVersion, boolean bootstrap) {
        if (environment.isManuallyDeployed() && !"hosted-vespa".equals(application.tenant().value()) && !bootstrap) {
            return Vtag.currentVersion;
        }
        return targetVersion;
    }

    public Slime createDeployLog() {
        Slime deployLog = new Slime();
        deployLog.setObject();
        return deployLog;
    }

    public Zone zone() {
        return new Zone(SystemName.from((String)this.configserverConfig.system()), Environment.from((String)this.configserverConfig.environment()), RegionName.from((String)this.configserverConfig.region()));
    }
}

