/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.LocalSessionLoader;
import com.yahoo.vespa.config.server.session.LocalSessionStateWatcher;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepo;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import java.io.File;
import java.io.FilenameFilter;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalSessionRepo
extends SessionRepo<LocalSession> {
    private static final Logger log = Logger.getLogger(LocalSessionRepo.class.getName());
    private static final FilenameFilter sessionApplicationsFilter = (dir, name) -> name.matches("\\d+");
    private static final Duration delay = Duration.ofMinutes(5L);
    private static final ScheduledExecutorService purgeOldSessionsExecutor = new ScheduledThreadPoolExecutor(1, ThreadFactoryFactory.getDaemonThreadFactory((String)"purge-old-sessions"));
    private final Map<Long, LocalSessionStateWatcher> sessionStateWatchers = new HashMap<Long, LocalSessionStateWatcher>();
    private final long sessionLifetime;
    private final Clock clock;
    private final Curator curator;

    public LocalSessionRepo(TenantFileSystemDirs tenantFileSystemDirs, LocalSessionLoader loader, Clock clock, long sessionLifeTime, Curator curator) {
        this(clock, curator, sessionLifeTime);
        this.loadSessions(tenantFileSystemDirs.sessionsPath(), loader);
        purgeOldSessionsExecutor.scheduleWithFixedDelay(this::purgeOldSessions, delay.getSeconds(), delay.getSeconds(), TimeUnit.SECONDS);
    }

    public LocalSessionRepo(Clock clock, Curator curator) {
        this(clock, curator, TimeUnit.DAYS.toMillis(1L));
    }

    private LocalSessionRepo(Clock clock, Curator curator, long sessionLifetime) {
        this.clock = clock;
        this.curator = curator;
        this.sessionLifetime = sessionLifetime;
    }

    @Override
    public synchronized void addSession(LocalSession session) {
        super.addSession(session);
        Path sessionsPath = TenantRepository.getSessionsPath(session.getTenantName());
        long sessionId = session.getSessionId();
        Curator.FileCache fileCache = this.curator.createFileCache(sessionsPath.append(String.valueOf(sessionId)).append("/sessionState").getAbsolute(), false);
        this.sessionStateWatchers.put(sessionId, new LocalSessionStateWatcher(fileCache, session, this));
    }

    private void loadSessions(File applicationsDir, LocalSessionLoader loader) {
        File[] applications = applicationsDir.listFiles(sessionApplicationsFilter);
        if (applications == null) {
            return;
        }
        for (File application : applications) {
            try {
                this.addSession(loader.loadSession(Long.parseLong(application.getName())));
            }
            catch (IllegalArgumentException e) {
                log.log(LogLevel.WARNING, "Could not load application '" + application.getAbsolutePath() + "':" + e.getMessage() + ", skipping it.");
            }
        }
    }

    public void purgeOldSessions() {
        log.log((Level)LogLevel.DEBUG, "Purging old sessions");
        try {
            ArrayList sessions = new ArrayList(this.listSessions());
            for (LocalSession candidate : sessions) {
                if (!this.hasExpired(candidate) || this.isActiveSession(candidate)) continue;
                this.deleteSession(candidate);
            }
        }
        catch (Throwable e) {
            log.log(LogLevel.WARNING, "Error when purging old sessions ", e);
        }
        log.log((Level)LogLevel.DEBUG, "Done purging old sessions");
    }

    private boolean hasExpired(LocalSession candidate) {
        return candidate.getCreateTime() + this.sessionLifetime <= TimeUnit.MILLISECONDS.toSeconds(this.clock.millis());
    }

    private boolean isActiveSession(LocalSession candidate) {
        return candidate.getStatus() == Session.Status.ACTIVATE;
    }

    void deleteSession(LocalSession session) {
        long sessionId = session.getSessionId();
        log.log((Level)LogLevel.DEBUG, "Deleting local session " + sessionId);
        LocalSessionStateWatcher watcher = this.sessionStateWatchers.remove(sessionId);
        if (watcher != null) {
            watcher.close();
        }
        this.removeSession(sessionId);
        NestedTransaction transaction = new NestedTransaction();
        session.delete(transaction);
        transaction.commit();
    }

    public void deleteAllSessions() {
        ArrayList sessions = new ArrayList(this.listSessions());
        for (LocalSession session : sessions) {
            this.deleteSession(session);
        }
    }
}

