/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.SystemName;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.Maintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.time.Duration;

public class FileDistributionMaintainer
extends Maintainer {
    private final ApplicationRepository applicationRepository;
    private final File fileReferencesDir;
    private final ConfigserverConfig configserverConfig;

    FileDistributionMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, ConfigserverConfig configserverConfig) {
        super(applicationRepository, curator, interval);
        this.applicationRepository = applicationRepository;
        this.configserverConfig = configserverConfig;
        this.fileReferencesDir = new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir()));
    }

    @Override
    protected void maintain() {
        boolean deleteFiles = SystemName.from((String)this.configserverConfig.system()) == SystemName.cd || Environment.from((String)this.configserverConfig.environment()).isTest();
        this.applicationRepository.deleteUnusedFiledistributionReferences(this.fileReferencesDir, deleteFiles);
    }
}

