/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.jdisc.state.StateMonitor;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.rpc.RpcServer;
import com.yahoo.vespa.config.server.version.VersionState;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigServerBootstrap
extends AbstractComponent
implements Runnable {
    private static final Logger log = Logger.getLogger(ConfigServerBootstrap.class.getName());
    private final ApplicationRepository applicationRepository;
    private final RpcServer server;
    private final Thread serverThread;
    private final VersionState versionState;
    private final StateMonitor stateMonitor;

    @Inject
    public ConfigServerBootstrap(ApplicationRepository applicationRepository, RpcServer server, VersionState versionState, StateMonitor stateMonitor) {
        this(applicationRepository, server, versionState, stateMonitor, true);
    }

    ConfigServerBootstrap(ApplicationRepository applicationRepository, RpcServer server, VersionState versionState, StateMonitor stateMonitor, boolean startMainThread) {
        this.applicationRepository = applicationRepository;
        this.server = server;
        this.versionState = versionState;
        this.stateMonitor = stateMonitor;
        this.serverThread = new Thread((Runnable)this, "configserver main");
        if (startMainThread) {
            this.start();
        }
    }

    private void start() {
        this.serverThread.start();
    }

    public void deconstruct() {
        log.log(LogLevel.INFO, "Stopping config server");
        this.server.stop();
        try {
            this.serverThread.join();
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "Error joining server thread on shutdown: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        if (this.versionState.isUpgraded()) {
            log.log(LogLevel.INFO, "Configserver upgrading from " + this.versionState.storedVersion() + " to " + this.versionState.currentVersion() + ". Redeploying all applications");
            try {
                this.applicationRepository.redeployAllApplications();
                this.versionState.saveNewVersion();
                log.log(LogLevel.INFO, "All applications redeployed successfully");
            }
            catch (Exception e) {
                log.log((Level)LogLevel.ERROR, "Redeployment of applications failed", e);
                return;
            }
        }
        this.stateMonitor.status(StateMonitor.Status.up);
        log.log(LogLevel.INFO, "Starting RPC server");
        this.server.run();
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.log((Level)LogLevel.ERROR, "Got interrupted", e);
                break;
            }
        } while (this.server.isRunning());
        log.log(LogLevel.INFO, "RPC server stopped");
        this.stateMonitor.status(StateMonitor.Status.down);
    }

    StateMonitor.Status status() {
        return this.stateMonitor.status();
    }
}

