/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.google.common.collect.HashMultiset;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.RemoteSessionFactory;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepo;
import com.yahoo.vespa.config.server.session.SessionStateWatcher;
import com.yahoo.vespa.config.server.tenant.Tenants;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.yolean.Exceptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public class RemoteSessionRepo
extends SessionRepo<RemoteSession>
implements NodeCacheListener,
PathChildrenCacheListener {
    private static final Logger log = Logger.getLogger(RemoteSessionRepo.class.getName());
    private final Curator curator;
    private final Path sessionsPath;
    private final RemoteSessionFactory remoteSessionFactory;
    private final Map<Long, SessionStateWatcher> sessionStateWatchers = new HashMap<Long, SessionStateWatcher>();
    private final ReloadHandler reloadHandler;
    private final MetricUpdater metrics;
    private final Curator.DirectoryCache directoryCache;
    private final TenantApplications applicationRepo;

    public RemoteSessionRepo(Curator curator, RemoteSessionFactory remoteSessionFactory, ReloadHandler reloadHandler, TenantName tenant, TenantApplications applicationRepo, MetricUpdater metricUpdater, ExecutorService executorService) {
        this.curator = curator;
        this.sessionsPath = Tenants.getSessionsPath(tenant);
        this.applicationRepo = applicationRepo;
        this.remoteSessionFactory = remoteSessionFactory;
        this.reloadHandler = reloadHandler;
        this.metrics = metricUpdater;
        this.directoryCache = curator.createDirectoryCache(this.sessionsPath.getAbsolute(), false, false, executorService);
        this.directoryCache.addListener((PathChildrenCacheListener)this);
        this.directoryCache.start();
        this.sessionsChanged();
    }

    public RemoteSessionRepo(TenantName tenantName) {
        this.curator = null;
        this.remoteSessionFactory = null;
        this.reloadHandler = null;
        this.sessionsPath = Tenants.getSessionsPath(tenantName);
        this.metrics = null;
        this.directoryCache = null;
        this.applicationRepo = null;
    }

    @Override
    public synchronized void addSession(RemoteSession session) {
        super.addSession(session);
        this.sessionAdded(session.getSessionId());
    }

    @Override
    public synchronized void removeSessionOrThrow(long id) {
        super.removeSessionOrThrow(id);
        this.sessionRemoved(id);
    }

    @Override
    public synchronized RemoteSession removeSession(long id) {
        RemoteSession session = (RemoteSession)super.removeSession(id);
        this.sessionRemoved(id);
        return session;
    }

    @Override
    public void removeSession(long id, NestedTransaction transaction) {
        super.removeSession(id, transaction);
        transaction.onCommitted(() -> this.sessionRemoved(id));
    }

    private void loadActiveSession(RemoteSession session) {
        this.tryReload(session.ensureApplicationLoaded(), session.logPre());
    }

    private void tryReload(ApplicationSet applicationSet, String logPre) {
        try {
            this.reloadHandler.reloadConfig(applicationSet);
            log.log(LogLevel.INFO, logPre + "Application activated successfully: " + applicationSet.getId());
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, logPre + "Skipping loading of application '" + applicationSet.getId() + "': " + Exceptions.toMessageString((Throwable)e));
        }
    }

    private List<Long> getSessionList(List<ChildData> children) {
        ArrayList<Long> sessions = new ArrayList<Long>();
        for (ChildData data : children) {
            sessions.add(Long.parseLong(Path.fromString((String)data.getPath()).getName()));
        }
        return sessions;
    }

    private synchronized void sessionsChanged() throws NumberFormatException {
        List<Long> sessions = this.getSessionList(this.directoryCache.getCurrentData());
        this.checkForRemovedSessions(sessions);
        this.checkForAddedSessions(sessions);
    }

    private void checkForRemovedSessions(List<Long> sessions) {
        for (RemoteSession session : this.listSessions()) {
            if (sessions.contains(session.getSessionId())) continue;
            this.sessionRemoved(session.getSessionId());
        }
    }

    private void checkForAddedSessions(List<Long> sessions) {
        for (Long sessionId : sessions) {
            if (this.getSession(sessionId) != null) continue;
            this.sessionAdded(sessionId);
        }
    }

    private void sessionAdded(long sessionId) {
        try {
            log.log((Level)LogLevel.DEBUG, "Adding session to RemoteSessionRepo: " + sessionId);
            RemoteSession session = this.remoteSessionFactory.createSession(sessionId);
            Path sessionPath = this.sessionsPath.append(String.valueOf(sessionId));
            Curator.FileCache fileCache = this.curator.createFileCache(sessionPath.append("/sessionState").getAbsolute(), false);
            fileCache.addListener((NodeCacheListener)this);
            this.loadSessionIfActive(session);
            this.sessionStateWatchers.put(sessionId, new SessionStateWatcher(fileCache, this.reloadHandler, session, this.metrics));
            this.internalAddSession(session);
            this.metrics.incAddedSessions();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed loading session " + sessionId + ": No config for this session can be served", e);
        }
    }

    private void sessionRemoved(long sessionId) {
        SessionStateWatcher watcher = this.sessionStateWatchers.remove(sessionId);
        watcher.close();
        this.internalRemoveSessionOrThrow(sessionId);
        this.metrics.incRemovedSessions();
    }

    private void loadSessionIfActive(RemoteSession session) {
        for (ApplicationId applicationId : this.applicationRepo.listApplications()) {
            try {
                if (this.applicationRepo.getSessionIdForApplication(applicationId) != session.getSessionId()) continue;
                log.log((Level)LogLevel.DEBUG, "Found active application for session " + session.getSessionId() + " , loading it");
                this.loadActiveSession(session);
                break;
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, session.logPre() + " error reading session id for " + applicationId);
            }
        }
    }

    public synchronized void close() {
        try {
            if (this.directoryCache != null) {
                this.directoryCache.close();
            }
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Exception when closing path cache", e);
        }
        finally {
            this.checkForRemovedSessions(new ArrayList<Long>());
        }
    }

    public void nodeChanged() throws Exception {
        HashMultiset sessionMetrics = HashMultiset.create();
        for (RemoteSession session : this.listSessions()) {
            sessionMetrics.add((Object)session.getStatus());
        }
        this.metrics.setNewSessions(sessionMetrics.count((Object)Session.Status.NEW));
        this.metrics.setPreparedSessions(sessionMetrics.count((Object)Session.Status.PREPARE));
        this.metrics.setActivatedSessions(sessionMetrics.count((Object)Session.Status.ACTIVATE));
        this.metrics.setDeactivatedSessions(sessionMetrics.count((Object)Session.Status.DEACTIVATE));
    }

    public void childEvent(CuratorFramework framework, PathChildrenCacheEvent event) throws Exception {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Got child event: " + event);
        }
        switch (event.getType()) {
            case CHILD_ADDED: {
                this.sessionsChanged();
                this.synchronizeOnNew(this.getSessionList(Collections.singletonList(event.getData())));
                break;
            }
            case CHILD_REMOVED: {
                this.sessionsChanged();
                break;
            }
            case CONNECTION_RECONNECTED: {
                this.sessionsChanged();
            }
        }
    }

    private void synchronizeOnNew(List<Long> sessionList) {
        for (long sessionId : sessionList) {
            RemoteSession session = (RemoteSession)this.getSession(sessionId);
            if (session == null) continue;
            log.log((Level)LogLevel.DEBUG, session.logPre() + "Confirming upload for session " + sessionId);
            session.confirmUpload();
        }
    }
}

