/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Version;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.SuperModelController;
import com.yahoo.vespa.config.server.SuperModelManager;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactoryFactory;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SuperModelRequestHandler
implements RequestHandler {
    private static final Logger log = Logger.getLogger(SuperModelRequestHandler.class.getName());
    private volatile SuperModelController handler;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final ConfigResponseFactory responseFactory;
    private final SuperModelManager superModelManager;
    private volatile boolean enabled = false;

    @Inject
    public SuperModelRequestHandler(ConfigDefinitionRepo configDefinitionRepo, ConfigserverConfig configserverConfig, SuperModelManager superModelManager) {
        this.configDefinitionRepo = configDefinitionRepo;
        this.responseFactory = ConfigResponseFactoryFactory.createFactory(configserverConfig);
        this.superModelManager = superModelManager;
        this.updateHandler();
    }

    public synchronized void reloadConfig(TenantName tenant, ApplicationSet applicationSet) {
        this.superModelManager.configActivated(tenant, applicationSet);
        this.updateHandler();
    }

    public synchronized void removeApplication(ApplicationId applicationId) {
        this.superModelManager.applicationRemoved(applicationId);
        this.updateHandler();
    }

    private void updateHandler() {
        this.handler = new SuperModelController(this.superModelManager.getSuperModelConfigProvider(), this.configDefinitionRepo, this.superModelManager.getGeneration(), this.responseFactory);
    }

    public SuperModelController getHandler() {
        return this.handler;
    }

    @Override
    public ConfigResponse resolveConfig(ApplicationId appId, GetConfigRequest req, Optional<Version> vespaVersion) {
        log.log((Level)LogLevel.DEBUG, () -> "SuperModelRequestHandler resolving " + req + " for app id '" + appId + "'");
        if (this.handler != null) {
            ConfigResponse configResponse = this.handler.resolveConfig(req);
            log.log((Level)LogLevel.DEBUG, () -> "SuperModelRequestHandler returning response for config " + req + " with generation " + configResponse.getGeneration());
            return configResponse;
        }
        return null;
    }

    public <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> configClass, ApplicationId applicationId, String configId) throws IOException {
        return this.handler.getConfig(configClass, applicationId, configId);
    }

    @Override
    public Set<ConfigKey<?>> listConfigs(ApplicationId appId, Optional<Version> vespaVersion, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ConfigKey<?>> listNamedConfigs(ApplicationId appId, Optional<Version> vespaVersion, ConfigKey<?> key, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ConfigKey<?>> allConfigsProduced(ApplicationId appId, Optional<Version> vespaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> allConfigIds(ApplicationId appID, Optional<Version> vespaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.enabled && appId.equals((Object)ApplicationId.global());
    }

    @Override
    public ApplicationId resolveApplicationId(String hostName) {
        return ApplicationId.global();
    }

    public void enable() {
        this.enabled = true;
    }
}

