/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.jrt.Supervisor;
import com.yahoo.vespa.config.server.filedistribution.ApplicationFileManager;
import com.yahoo.vespa.config.server.filedistribution.FileDBRegistry;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionImpl;
import java.io.File;

public class FileDistributionProvider {
    private final FileRegistry fileRegistry;
    private final FileDistribution fileDistribution;

    public FileDistributionProvider(Supervisor supervisor, File applicationDir) {
        this.ensureDirExists(FileDistribution.getDefaultFileDBPath());
        this.fileDistribution = new FileDistributionImpl(supervisor);
        this.fileRegistry = new FileDBRegistry(new ApplicationFileManager(applicationDir, new FileDirectory()));
    }

    FileDistributionProvider(FileRegistry fileRegistry, FileDistribution fileDistribution) {
        this.fileRegistry = fileRegistry;
        this.fileDistribution = fileDistribution;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public FileDistribution getFileDistribution() {
        return this.fileDistribution;
    }

    private void ensureDirExists(File dir) {
        boolean success;
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new RuntimeException("Could not create directory " + dir.getPath());
        }
    }
}

