/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.rpc;

import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.text.Utf8Array;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.LZ4PayloadCompressor;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.SlimeConfigResponse;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.util.ConfigUtils;

public class LZ4ConfigResponseFactory
implements ConfigResponseFactory {
    private static LZ4PayloadCompressor compressor = new LZ4PayloadCompressor();

    @Override
    public ConfigResponse createResponse(ConfigPayload payload, InnerCNode defFile, long generation) {
        Utf8Array rawPayload = payload.toUtf8Array(true);
        String configMd5 = ConfigUtils.getMd5((Utf8Array)rawPayload);
        CompressionInfo info = CompressionInfo.create((CompressionType)CompressionType.LZ4, (int)rawPayload.getByteLength());
        Utf8Array compressed = new Utf8Array(compressor.compress(rawPayload.getBytes()));
        return new SlimeConfigResponse(compressed, defFile, generation, configMd5, info);
    }
}

