/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.jdisc.application.UriPattern;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.deploy.DeployHandlerLogger;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.SessionCreateResponse;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.net.URI;
import java.time.Duration;

public class SessionCreateHandler
extends SessionHandler {
    private static final String fromPattern = "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*";
    private final Tenants tenants;
    private final Duration zookeeperBarrierTimeout;

    @Inject
    public SessionCreateHandler(LoggingRequestHandler.Context ctx, ApplicationRepository applicationRepository, Tenants tenants, ConfigserverConfig configserverConfig) {
        super(ctx, applicationRepository);
        this.tenants = tenants;
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
    }

    @Override
    protected HttpResponse handlePOST(HttpRequest request) {
        long sessionId;
        Slime deployLog = this.createDeployLog();
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        Utils.checkThatTenantExists(this.tenants, tenantName);
        Tenant tenant = this.tenants.getTenant(tenantName);
        TimeoutBudget timeoutBudget = SessionHandler.getTimeoutBudget(request, this.zookeeperBarrierTimeout);
        DeployHandlerLogger logger = SessionCreateHandler.createLogger(request, deployLog, tenantName);
        if (request.hasProperty("from")) {
            ApplicationId applicationId = SessionCreateHandler.getFromApplicationId(request);
            sessionId = this.applicationRepository.createSessionFromExisting(tenant, logger, timeoutBudget, applicationId);
        } else {
            SessionCreateHandler.validateDataAndHeader(request);
            String name = SessionCreateHandler.getNameProperty(request, logger);
            sessionId = this.applicationRepository.createSession(tenant, timeoutBudget, request.getData(), request.getHeader("Content-Type"), name);
        }
        return this.createResponse(request, tenantName, deployLog, sessionId);
    }

    private static ApplicationId getFromApplicationId(HttpRequest request) {
        String from = request.getProperty("from");
        if (from == null || "".equals(from)) {
            throw new BadRequestException("Parameter 'from' has illegal value '" + from + "'");
        }
        return SessionCreateHandler.getAndValidateFromParameter(URI.create(from));
    }

    private static ApplicationId getAndValidateFromParameter(URI from) {
        UriPattern.Match match = new UriPattern(fromPattern).match(from);
        if (match == null || match.groupCount() < 7) {
            throw new BadRequestException("Parameter 'from' has illegal value '" + from + "'");
        }
        return new ApplicationId.Builder().tenant(match.group(2)).applicationName(match.group(3)).instanceName(match.group(6)).build();
    }

    static DeployHandlerLogger createLogger(HttpRequest request, Slime deployLog, TenantName tenant) {
        return SessionHandler.createLogger(deployLog, request, new ApplicationId.Builder().tenant(tenant).applicationName("-").build());
    }

    static String getNameProperty(HttpRequest request, DeployLogger logger) {
        String name = request.getProperty("name");
        if (name == null) {
            name = "default";
            logger.log(LogLevel.INFO, "No application name given, using '" + name + "'");
        }
        return name;
    }

    static void validateDataAndHeader(HttpRequest request) {
        if (request.getData() == null) {
            throw new BadRequestException("Request contains no data");
        }
        String header = request.getHeader("Content-Type");
        if (header == null) {
            throw new BadRequestException("Request contains no Content-Type header");
        }
        if (!header.equals("application/x-gzip") && !header.equals("application/zip")) {
            throw new BadRequestException("Request contains invalid Content-Type header, only 'application/x-gzip' and 'application/zip' are supported");
        }
    }

    private HttpResponse createResponse(HttpRequest request, TenantName tenantName, Slime deployLog, long sessionId) {
        return new SessionCreateResponse(tenantName, deployLog, deployLog.get()).createResponse(request.getHost(), request.getPort(), sessionId);
    }
}

