/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.config.provision.TenantName;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.jdisc.application.UriPattern;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.net.URI;

public class Utils {
    public static BindingMatch<?> getBindingMatch(com.yahoo.container.jdisc.HttpRequest req, String uriPattern) {
        HttpRequest jDiscRequest = req.getJDiscRequest();
        BindingMatch bm = jDiscRequest.getBindingMatch();
        if (bm == null) {
            UriPattern pattern = new UriPattern(uriPattern);
            bm = new BindingMatch(pattern.match(URI.create(jDiscRequest.getUri().toString())), new Object(), pattern);
        }
        return bm;
    }

    public static String getUrlBase(com.yahoo.container.jdisc.HttpRequest request, String pathPrefix) {
        return request.getUri().getScheme() + "://" + request.getHost() + ":" + request.getPort() + pathPrefix;
    }

    public static void checkThatTenantExists(Tenants tenants, TenantName tenantName) {
        if (!tenants.checkThatTenantExists(tenantName)) {
            throw new NotFoundException("Tenant '" + tenantName + "' was not found.");
        }
    }

    public static TenantName getTenantNameFromSessionRequest(com.yahoo.container.jdisc.HttpRequest request) {
        BindingMatch<?> bm = Utils.getBindingMatch(request, "http://*/application/v2/tenant/*/session*");
        return TenantName.from((String)bm.group(2));
    }

    public static TenantName getTenantNameFromApplicationsRequest(com.yahoo.container.jdisc.HttpRequest request) {
        BindingMatch<?> bm = Utils.getBindingMatch(request, "http://*/application/v2/tenant/*/application*");
        return TenantName.from((String)bm.group(2));
    }
}

