/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServerCache {
    private final Map<ConfigDefinitionKey, ConfigDefinition> defs = new ConcurrentHashMap<ConfigDefinitionKey, ConfigDefinition>();
    private final Map<ConfigCacheKey, String> md5Sums = new ConcurrentHashMap<ConfigCacheKey, String>();
    private final Map<String, ConfigResponse> md5ToConfig = new ConcurrentHashMap<String, ConfigResponse>();

    public void addDef(ConfigDefinitionKey key, ConfigDefinition def) {
        this.defs.put(key, def);
    }

    public void put(ConfigCacheKey key, ConfigResponse config, String configMd5) {
        this.md5Sums.put(key, configMd5);
        this.md5ToConfig.put(configMd5, config);
    }

    public ConfigResponse get(ConfigCacheKey key) {
        String md5 = this.md5Sums.get(key);
        if (md5 == null) {
            return null;
        }
        return this.md5ToConfig.get(md5);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cache\n");
        sb.append("defs:        ").append(this.defs.size()).append("\n");
        sb.append("md5sums:     ").append(this.md5Sums.size()).append("\n");
        sb.append("md5ToConfig: ").append(this.md5ToConfig.size()).append("\n");
        return sb.toString();
    }

    public ConfigDefinition getDef(ConfigDefinitionKey defKey) {
        return this.defs.get(defKey);
    }

    public int configElems() {
        return this.md5ToConfig.size();
    }

    public int checkSumElems() {
        return this.md5Sums.size();
    }
}

