/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.monitoring;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.docproc.jdisc.metric.NullMetric;
import com.yahoo.jdisc.Metric;
import com.yahoo.log.LogLevel;
import com.yahoo.statistics.Counter;
import com.yahoo.statistics.Statistics;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.MetricUpdaterFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Metrics
extends TimerTask
implements MetricUpdaterFactory {
    private static final Logger log = Logger.getLogger(Metrics.class.getName());
    private static final String METRIC_REQUESTS = Metrics.getMetricName("requests");
    private static final String METRIC_FAILED_REQUESTS = Metrics.getMetricName("failedRequests");
    private static final String METRIC_FREE_MEMORY = Metrics.getMetricName("freeMemory");
    private static final String METRIC_LATENCY = Metrics.getMetricName("latency");
    private final Counter requests;
    private final Counter failedRequests;
    private final Counter procTimeCounter;
    private final Metric metric;
    private final Map<Map<String, String>, MetricUpdater> metricUpdaters = new ConcurrentHashMap<Map<String, String>, MetricUpdater>();
    private final Timer timer = new Timer();

    @Inject
    public Metrics(Metric metric, Statistics statistics, HealthMonitorConfig healthMonitorConfig) {
        this.metric = metric;
        this.requests = this.createCounter(METRIC_REQUESTS, statistics);
        this.failedRequests = this.createCounter(METRIC_FAILED_REQUESTS, statistics);
        this.procTimeCounter = this.createCounter("procTime", statistics);
        this.timer.scheduleAtFixedRate((TimerTask)this, 5000L, (long)(healthMonitorConfig.snapshot_interval() * 1000.0));
        log.log((Level)LogLevel.DEBUG, "Metric update interval is " + healthMonitorConfig.snapshot_interval() + " seconds");
    }

    public static Metrics createTestMetrics() {
        NullMetric metric = new NullMetric();
        Statistics.NullImplementation statistics = new Statistics.NullImplementation();
        HealthMonitorConfig.Builder builder = new HealthMonitorConfig.Builder();
        builder.snapshot_interval(60.0);
        return new Metrics((Metric)metric, (Statistics)statistics, new HealthMonitorConfig(builder));
    }

    private Counter createCounter(String name, Statistics statistics) {
        return new Counter(name, statistics, false);
    }

    void incrementRequests(Metric.Context metricContext) {
        this.requests.increment(1L);
        this.metric.add(METRIC_REQUESTS, (Number)1, metricContext);
    }

    void incrementFailedRequests(Metric.Context metricContext) {
        this.failedRequests.increment(1L);
        this.metric.add(METRIC_FAILED_REQUESTS, (Number)1, metricContext);
    }

    void incrementProcTime(long increment, Metric.Context metricContext) {
        this.procTimeCounter.increment(increment);
        this.metric.set(METRIC_LATENCY, (Number)increment, metricContext);
    }

    public long getRequests() {
        return this.requests.get();
    }

    public Metric getMetric() {
        return this.metric;
    }

    public MetricUpdater removeMetricUpdater(Map<String, String> dimensions) {
        return this.metricUpdaters.remove(dimensions);
    }

    public static Map<String, String> createDimensions(ApplicationId applicationId) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("tenantName", applicationId.tenant().value());
        properties.put("applicationName", applicationId.application().value());
        properties.put("applicationInstance", applicationId.instance().value());
        return properties;
    }

    public static Map<String, String> createDimensions(TenantName tenant) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("tenantName", tenant.value());
        return properties;
    }

    @Override
    public synchronized MetricUpdater getOrCreateMetricUpdater(Map<String, String> dimensions) {
        if (this.metricUpdaters.containsKey(dimensions)) {
            return this.metricUpdaters.get(dimensions);
        }
        MetricUpdater metricUpdater = new MetricUpdater(this, dimensions);
        this.metricUpdaters.put(dimensions, metricUpdater);
        return metricUpdater;
    }

    @Override
    public void run() {
        for (MetricUpdater metricUpdater : this.metricUpdaters.values()) {
            log.log((Level)LogLevel.DEBUG, "Running metric updater for static values for " + metricUpdater.getDimensions());
            for (Map.Entry<String, Number> fixedMetric : metricUpdater.getStaticMetrics().entrySet()) {
                log.log((Level)LogLevel.DEBUG, "Setting " + fixedMetric.getKey());
                this.metric.set(fixedMetric.getKey(), fixedMetric.getValue(), metricUpdater.getMetricContext());
            }
        }
        this.setRegularMetrics();
        this.timer.purge();
    }

    private void setRegularMetrics() {
        this.metric.set(METRIC_FREE_MEMORY, (Number)Runtime.getRuntime().freeMemory(), null);
    }

    void increment(String metricName, Metric.Context context) {
        this.metric.add(metricName, (Number)1, context);
    }

    void set(String metricName, Number value, Metric.Context context) {
        this.metric.set(metricName, value, context);
    }

    static String getMetricName(String name) {
        return "configserver." + name;
    }
}

