/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class StaticResponse
extends HttpResponse {
    private final String contentType;
    private final InputStream body;

    public StaticResponse(int status, String contentType, InputStream body) {
        super(status);
        this.contentType = contentType;
        this.body = body;
    }

    public StaticResponse(int status, String contentType, String body) {
        this(status, contentType, new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
    }

    public void render(OutputStream outputStream) throws IOException {
        IOUtils.copy((InputStream)this.body, (OutputStream)outputStream);
        this.body.close();
    }

    public String getContentType() {
        return this.contentType;
    }
}

