/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Version;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.VersionDoesNotExistException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ApplicationSet {
    private final Version latestVersion;
    private final ApplicationId applicationId;
    private final long generation;
    private final HashMap<Version, Application> applications = new HashMap();

    private ApplicationSet(List<Application> applicationList) {
        this.applicationId = applicationList.get(0).getId();
        this.generation = applicationList.get(0).getApplicationGeneration();
        for (Application application : applicationList) {
            this.applications.put(application.getVespaVersion(), application);
            if (application.getId().equals((Object)this.applicationId)) continue;
            throw new IllegalArgumentException("Trying to create set with different application ids");
        }
        this.latestVersion = (Version)this.applications.keySet().stream().max((a, b) -> a.compareTo(b)).get();
    }

    public Application getForVersionOrLatest(Optional<Version> optionalVersion, Instant now) {
        return this.resolveForVersion(optionalVersion.orElse(this.latestVersion), now);
    }

    private Application resolveForVersion(Version vespaVersion, Instant now) {
        Application application = this.applications.get(vespaVersion);
        if (application != null) {
            return application;
        }
        Application latest = this.applications.get(this.latestVersion);
        if (latest.getModel().allowModelVersionMismatch(now)) {
            return latest;
        }
        throw new VersionDoesNotExistException(String.format("No application with vespa version %s exists", vespaVersion.toString()));
    }

    public ApplicationId getId() {
        return this.applicationId;
    }

    public static ApplicationSet fromList(List<Application> applications) {
        return new ApplicationSet(applications);
    }

    public static ApplicationSet fromSingle(Application application) {
        return ApplicationSet.fromList(Arrays.asList(application));
    }

    public Collection<String> getAllHosts() {
        return this.applications.values().stream().flatMap(app -> app.getModel().getHosts().stream().map(HostInfo::getHostname)).collect(Collectors.toList());
    }

    public void updateHostMetrics() {
        for (Application application : this.applications.values()) {
            application.updateHostMetrics(application.getModel().getHosts().size());
        }
    }

    public long getApplicationGeneration() {
        return this.generation;
    }
}

