/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.config.provision.Deployer;
import com.yahoo.container.jdisc.state.StateMonitor;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.rpc.RpcServer;
import com.yahoo.vespa.config.server.version.VersionState;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigServerBootstrap
extends AbstractComponent
implements Runnable {
    private static final Logger log = Logger.getLogger(ConfigServerBootstrap.class.getName());
    private final ApplicationRepository applicationRepository;
    private final RpcServer server;
    private final Thread serverThread;
    private final Deployer deployer;
    private final VersionState versionState;
    private final StateMonitor stateMonitor;

    @Inject
    public ConfigServerBootstrap(ApplicationRepository applicationRepository, RpcServer server, Deployer deployer, VersionState versionState, StateMonitor stateMonitor) {
        this.applicationRepository = applicationRepository;
        this.server = server;
        this.deployer = deployer;
        this.versionState = versionState;
        this.stateMonitor = stateMonitor;
        this.serverThread = new Thread((Runnable)this, "configserver main");
        this.serverThread.start();
    }

    public void deconstruct() {
        log.log(LogLevel.INFO, "Stopping config server");
        this.server.stop();
        try {
            this.serverThread.join();
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "Error joining server thread on shutdown: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        if (this.versionState.isUpgraded()) {
            log.log(LogLevel.INFO, "Configserver upgraded from " + this.versionState.storedVersion() + " to " + this.versionState.currentVersion() + ". Redeploying all applications");
            try {
                this.applicationRepository.redeployAllApplications(this.deployer);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Redeploying applications failed", e);
            }
            log.log(LogLevel.INFO, "All applications redeployed");
        }
        this.versionState.saveNewVersion();
        this.stateMonitor.status(StateMonitor.Status.up);
        log.log((Level)LogLevel.DEBUG, "Starting RPC server");
        this.server.run();
        log.log((Level)LogLevel.DEBUG, "RPC server stopped");
        this.stateMonitor.status(StateMonitor.Status.down);
    }
}

