/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.server.http.ContentRequest;
import com.yahoo.vespa.config.server.http.Utils;

public class ApplicationContentRequest
extends ContentRequest {
    private static final String uriPattern = "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/content/*";
    private final ApplicationId applicationId;
    private final Zone zone;

    ApplicationContentRequest(HttpRequest request, long sessionId, ApplicationId applicationId, Zone zone, String contentPath, ApplicationFile applicationFile) {
        super(request, sessionId, contentPath, applicationFile);
        this.applicationId = applicationId;
        this.zone = zone;
    }

    static String getContentPath(HttpRequest request) {
        BindingMatch<?> bm = Utils.getBindingMatch(request, uriPattern);
        return bm.group(7);
    }

    @Override
    public String getPathPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append("/application/v2/tenant/").append(this.applicationId.tenant().value());
        sb.append("/application/").append(this.applicationId.application().value());
        sb.append("/environment/").append(this.zone.environment().value());
        sb.append("/region/").append(this.zone.region().value());
        sb.append("/instance/").append(this.applicationId.instance().value());
        return sb.toString();
    }
}

