/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.SessionActiveResponse;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.Tenants;
import java.time.Duration;

public class SessionActiveHandler
extends SessionHandler {
    private static final Duration DEFAULT_ACTIVATE_TIMEOUT = Duration.ofMinutes(2L);
    private final Tenants tenants;
    private final Zone zone;

    @Inject
    public SessionActiveHandler(LoggingRequestHandler.Context ctx, ApplicationRepository applicationRepository, Tenants tenants, Zone zone) {
        super(ctx, applicationRepository);
        this.tenants = tenants;
        this.zone = zone;
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        Utils.checkThatTenantExists(this.tenants, tenantName);
        Tenant tenant = this.tenants.getTenant(tenantName);
        TimeoutBudget timeoutBudget = SessionActiveHandler.getTimeoutBudget(request, DEFAULT_ACTIVATE_TIMEOUT);
        Long sessionId = SessionActiveHandler.getSessionIdV2(request);
        ApplicationId applicationId = this.applicationRepository.activate(tenant, sessionId, timeoutBudget, this.shouldIgnoreLockFailure(request), this.shouldIgnoreSessionStaleFailure(request));
        ApplicationMetaData metaData = this.applicationRepository.getMetadataFromSession(tenant, sessionId);
        return new SessionActiveResponse(metaData.getSlime(), request, applicationId, sessionId, this.zone);
    }

    private boolean shouldIgnoreLockFailure(HttpRequest request) {
        return request.getBooleanProperty("force");
    }

    private boolean shouldIgnoreSessionStaleFailure(HttpRequest request) {
        return request.getBooleanProperty("force");
    }
}

